@extends('layouts.admin')

@section('title', 'Payment Verification')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Bank Transfer Payment Verification</h1>

    <!-- Status Filter -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <div class="flex gap-2">
            <a href="{{ route('admin.payment-verification.index', ['status' => 'pending_verification']) }}" 
                class="px-4 py-2 rounded {{ $status === 'pending_verification' ? 'bg-yellow-600 text-white' : 'bg-gray-200' }}">
                Pending Verification ({{ \App\Models\Booking::where('payment_method', 'bank_transfer')->where('payment_status', 'pending_verification')->count() }})
            </a>
            <a href="{{ route('admin.payment-verification.index', ['status' => 'paid']) }}" 
                class="px-4 py-2 rounded {{ $status === 'paid' ? 'bg-green-600 text-white' : 'bg-gray-200' }}">
                Verified
            </a>
            <a href="{{ route('admin.payment-verification.index', ['status' => 'failed']) }}" 
                class="px-4 py-2 rounded {{ $status === 'failed' ? 'bg-red-600 text-white' : 'bg-gray-200' }}">
                Rejected
            </a>
        </div>
    </div>

    <!-- Payments List -->
    <div class="space-y-4">
        @forelse($bookings as $booking)
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex justify-between items-start mb-4">
                    <div class="flex-1">
                        <div class="flex items-center gap-3 mb-2">
                            <h3 class="text-xl font-bold">{{ $booking->property->title }}</h3>
                            <span class="px-3 py-1 rounded text-sm font-semibold
                                {{ $booking->payment_status === 'pending_verification' ? 'bg-yellow-100 text-yellow-800' : 
                                   ($booking->payment_status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800') }}">
                                {{ ucfirst(str_replace('_', ' ', $booking->payment_status)) }}
                            </span>
                        </div>
                        <p class="text-gray-600 text-sm mb-1">
                            <strong>Customer:</strong> {{ $booking->user->name }} ({{ $booking->user->email }})
                        </p>
                        <p class="text-gray-600 text-sm mb-1">
                            <strong>Vendor:</strong> {{ $booking->vendor->company_name }}
                        </p>
                        <p class="text-gray-600 text-sm mb-1">
                            <strong>Dates:</strong> {{ $booking->start_date->format('M d, Y') }} - {{ $booking->end_date->format('M d, Y') }} ({{ $booking->nights_count }} nights)
                        </p>
                        <p class="text-gray-600 text-sm">
                            <strong>Reference:</strong> {{ $booking->payment_reference }}
                        </p>
                    </div>
                    
                    <div class="text-right">
                        <p class="text-2xl font-bold text-primary">₦{{ number_format($booking->total_amount) }}</p>
                        <p class="text-sm text-gray-600">{{ $booking->created_at->diffForHumans() }}</p>
                    </div>
                </div>

                @if($booking->payment_proof)
                    <div class="border-t pt-4 mb-4">
                        <h4 class="font-semibold mb-2">Payment Proof:</h4>
                        <div class="flex gap-4 items-start">
                            <a href="{{ asset('storage/' . $booking->payment_proof) }}" target="_blank"
                                class="text-primary hover:underline flex items-center">
                                <i class="fas fa-file-image mr-2"></i> View Uploaded Receipt
                            </a>
                            @if($booking->payment_notes)
                                <div class="flex-1">
                                    <p class="text-sm text-gray-600"><strong>Notes:</strong> {{ $booking->payment_notes }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                @if($booking->verified_by)
                    <div class="border-t pt-4 mb-4 bg-light-bg p-3 rounded">
                        <p class="text-sm">
                            <i class="fas fa-user-check text-green-600 mr-2"></i>
                            <strong>Verified by:</strong> {{ $booking->verifiedBy->name }} 
                            on {{ $booking->verified_at->format('M d, Y H:i') }}
                        </p>
                    </div>
                @endif

                @if($booking->payment_status === 'pending_verification')
                    <div class="flex gap-2 border-t pt-4">
                        <form method="POST" action="{{ route('admin.payment-verification.approve', $booking) }}" class="flex-1">
                            @csrf
                            <button type="submit" 
                                class="w-full bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 font-semibold">
                                <i class="fas fa-check mr-2"></i> Verify & Confirm Booking
                            </button>
                        </form>
                        
                        <button onclick="openRejectModal({{ $booking->id }})" 
                            class="flex-1 bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 font-semibold">
                            <i class="fas fa-times mr-2"></i> Reject Payment
                        </button>
                    </div>
                @endif
            </div>
        @empty
            <div class="bg-white rounded-lg shadow-md p-12 text-center">
                <p class="text-gray-600">No payments found with status: {{ str_replace('_', ' ', $status) }}</p>
            </div>
        @endforelse
    </div>

    <div class="mt-6">
        {{ $bookings->links() }}
    </div>
</div>

<!-- Reject Modal -->
<div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-8 max-w-md w-full mx-4">
        <h2 class="text-2xl font-bold mb-4">Reject Payment</h2>
        
        <form id="reject-form" method="POST">
            @csrf
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Reason for Rejection *</label>
                <textarea name="rejection_reason" rows="4" required
                    placeholder="Please provide a detailed reason..."
                    class="w-full border rounded px-4 py-2"></textarea>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-4 py-3 rounded hover:bg-gray-300 font-semibold">
                    Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-red-600 text-white px-4 py-3 rounded hover:bg-red-700 font-semibold">
                    Reject Payment
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openRejectModal(bookingId) {
    document.getElementById('reject-form').action = `/admin/payment-verification/${bookingId}/reject`;
    document.getElementById('reject-modal').classList.remove('hidden');
}
</script>
@endsection
