@extends('layouts.admin')

@section('title', 'Payment Methods')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Payment Methods Management</h1>

    <div class="space-y-6">
        @foreach($paymentMethods as $method)
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex justify-between items-start mb-4">
                    <div class="flex items-center">
                        @if($method->slug === 'paystack')
                            <div class="bg-primary/10 rounded-full p-3 mr-4">
                                <i class="fas fa-credit-card text-primary text-2xl"></i>
                            </div>
                        @elseif($method->slug === 'flutterwave')
                            <div class="bg-orange-100 rounded-full p-3 mr-4">
                                <i class="fas fa-wallet text-orange-600 text-2xl"></i>
                            </div>
                        @else
                            <div class="bg-green-100 rounded-full p-3 mr-4">
                                <i class="fas fa-university text-green-600 text-2xl"></i>
                            </div>
                        @endif
                        
                        <div>
                            <h3 class="text-xl font-bold">{{ $method->name }}</h3>
                            <p class="text-gray-600 text-sm">{{ $method->description }}</p>
                        </div>
                    </div>
                    
                    <div class="flex items-center gap-3">
                        <span class="px-3 py-1 rounded text-sm font-semibold
                            {{ $method->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-secondary' }}">
                            {{ $method->is_active ? 'Active' : 'Inactive' }}
                        </span>
                        
                        <button onclick="openEditModal({{ $method->id }}, '{{ $method->name }}', '{{ $method->description }}', {{ $method->display_order }}, '{{ $method->slug }}')"
                            class="text-primary hover:text-blue-800">
                            <i class="fas fa-edit text-lg"></i>
                        </button>
                        
                        <form method="POST" action="{{ route('admin.payment-methods.toggle', $method) }}">
                            @csrf
                            <button type="submit" 
                                class="px-4 py-2 rounded font-semibold
                                    {{ $method->is_active ? 'bg-gray-200 text-gray-700 hover:bg-gray-300' : 'bg-green-600 text-white hover:bg-green-700' }}">
                                {{ $method->is_active ? 'Deactivate' : 'Activate' }}
                            </button>
                        </form>
                    </div>
                </div>

                @if($method->slug === 'bank_transfer')
                    <div class="border-t pt-4 mt-4">
                        <h4 class="font-semibold mb-3">Bank Account Details</h4>
                        <div class="grid md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="text-gray-600">Bank Name:</span>
                                <p class="font-semibold">{{ $method->settings['bank_name'] ?? 'Not set' }}</p>
                            </div>
                            <div>
                                <span class="text-gray-600">Account Name:</span>
                                <p class="font-semibold">{{ $method->settings['account_name'] ?? 'Not set' }}</p>
                            </div>
                            <div>
                                <span class="text-gray-600">Account Number:</span>
                                <p class="font-semibold">{{ $method->settings['account_number'] ?? 'Not set' }}</p>
                            </div>
                        </div>
                    </div>
                @elseif(in_array($method->slug, ['paystack', 'flutterwave']))
                    <div class="border-t pt-4 mt-4">
                        <div class="flex items-center text-sm">
                            @if($method->slug === 'paystack' && !empty(config('services.paystack.secret_key')))
                                <i class="fas fa-check-circle text-green-600 mr-2"></i>
                                <span class="text-green-600">API Keys Configured</span>
                            @elseif($method->slug === 'flutterwave' && !empty(config('services.flutterwave.secret_key')))
                                <i class="fas fa-check-circle text-green-600 mr-2"></i>
                                <span class="text-green-600">API Keys Configured</span>
                            @else
                                <i class="fas fa-exclamation-triangle text-yellow-600 mr-2"></i>
                                <span class="text-yellow-600">API Keys Not Configured - Check .env file</span>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        @endforeach
    </div>
</div>

<!-- Edit Modal -->
<div id="edit-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-8 max-w-2xl w-full mx-4 max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold">Edit Payment Method</h2>
            <button onclick="document.getElementById('edit-modal').classList.add('hidden')" 
                class="text-gray-500 hover:text-gray-700">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <form id="edit-form" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Name *</label>
                <input type="text" id="edit-name" name="name" required
                    class="w-full border rounded px-4 py-2">
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Description</label>
                <textarea id="edit-description" name="description" rows="2"
                    class="w-full border rounded px-4 py-2"></textarea>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Display Order *</label>
                <input type="number" id="edit-display-order" name="display_order" min="0" required
                    class="w-full border rounded px-4 py-2">
            </div>

            <!-- Bank Transfer Fields -->
            <div id="bank-fields" class="hidden">
                <h3 class="font-bold text-lg mb-3 border-t pt-4">Bank Account Details</h3>
                
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Bank Name *</label>
                    <input type="text" id="edit-bank-name" name="bank_name"
                        class="w-full border rounded px-4 py-2">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Account Name *</label>
                    <input type="text" id="edit-account-name" name="account_name"
                        class="w-full border rounded px-4 py-2">
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Account Number *</label>
                    <input type="text" id="edit-account-number" name="account_number"
                        class="w-full border rounded px-4 py-2">
                </div>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('edit-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-4 py-3 rounded hover:bg-gray-300 font-semibold">
                    Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-primary text-white px-4 py-3 rounded hover:bg-primary-dark font-semibold">
                    Update Method
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openEditModal(id, name, description, displayOrder, slug) {
    document.getElementById('edit-form').action = `/admin/payment-methods/${id}`;
    document.getElementById('edit-name').value = name;
    document.getElementById('edit-description').value = description;
    document.getElementById('edit-display-order').value = displayOrder;
    
    // Show bank fields only for bank_transfer
    const bankFields = document.getElementById('bank-fields');
    if (slug === 'bank_transfer') {
        bankFields.classList.remove('hidden');
        // Load bank details from the page
        const methodCard = event.target.closest('.bg-white');
        const bankDetails = methodCard.querySelectorAll('.font-semibold');
        if (bankDetails.length >= 3) {
            document.getElementById('edit-bank-name').value = bankDetails[0].textContent !== 'Not set' ? bankDetails[0].textContent : '';
            document.getElementById('edit-account-name').value = bankDetails[1].textContent !== 'Not set' ? bankDetails[1].textContent : '';
            document.getElementById('edit-account-number').value = bankDetails[2].textContent !== 'Not set' ? bankDetails[2].textContent : '';
        }
    } else {
        bankFields.classList.add('hidden');
    }
    
    document.getElementById('edit-modal').classList.remove('hidden');
}
</script>
@endsection
