@extends('layouts.admin')

@section('title', 'KYC Approvals')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-id-card mr-3"></i>KYC Verification Management
                    </h1>
                    <p class="text-primary-light">Review and approve vendor identity documents</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                    <p class="text-sm opacity-90">Pending Reviews</p>
                    <p class="text-3xl font-bold">{{ \App\Models\Vendor::where('kyc_status', 'pending')->whereNotNull('kyc_submitted_at')->count() }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Filter -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-8">
        <div class="flex items-center gap-3">
            <i class="fas fa-filter text-primary text-xl"></i>
            <h3 class="font-bold text-lg text-gray-800">Filter by Status:</h3>
        </div>
        <div class="flex gap-3 mt-4">
            <a href="{{ route('admin.kyc.index', ['status' => 'pending']) }}" 
                class="flex-1 px-6 py-3 rounded-lg font-semibold text-center transition transform hover:scale-105 {{ $status === 'pending' ? 'bg-yellow-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}">
                <i class="fas fa-clock mr-2"></i>Pending
                <span class="ml-2 bg-white/30 px-2 py-1 rounded-full text-xs">{{ \App\Models\Vendor::where('kyc_status', 'pending')->whereNotNull('kyc_submitted_at')->count() }}</span>
            </a>
            <a href="{{ route('admin.kyc.index', ['status' => 'approved']) }}" 
                class="flex-1 px-6 py-3 rounded-lg font-semibold text-center transition transform hover:scale-105 {{ $status === 'approved' ? 'bg-green-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}">
                <i class="fas fa-check-circle mr-2"></i>Approved
            </a>
            <a href="{{ route('admin.kyc.index', ['status' => 'rejected']) }}" 
                class="flex-1 px-6 py-3 rounded-lg font-semibold text-center transition transform hover:scale-105 {{ $status === 'rejected' ? 'bg-red-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}">
                <i class="fas fa-times-circle mr-2"></i>Rejected
            </a>
        </div>
    </div>

    <!-- KYC List -->
    <div class="space-y-6">
        @forelse($vendors as $vendor)
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300">
                <!-- Card Header -->
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 p-6 border-b-2 border-primary/20">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-2">
                                <div class="bg-primary/10 p-3 rounded-lg">
                                    <i class="fas fa-building text-primary text-2xl"></i>
                                </div>
                                <div>
                                    <h3 class="text-2xl font-bold text-gray-800">{{ $vendor->company_name }}</h3>
                                    <p class="text-gray-600 flex items-center gap-2">
                                        <i class="fas fa-user text-primary"></i>
                                        {{ $vendor->user->name }}
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center gap-4 text-sm text-gray-600 mt-3">
                                <span class="flex items-center">
                                    <i class="fas fa-envelope text-primary mr-2"></i>
                                    {{ $vendor->user->email }}
                                </span>
                                <span class="flex items-center">
                                    <i class="fas fa-calendar text-primary mr-2"></i>
                                    Submitted: {{ $vendor->kyc_submitted_at->format('M d, Y H:i') }}
                                </span>
                            </div>
                        </div>
                        <span class="px-4 py-2 rounded-full text-sm font-bold shadow-lg
                            {{ $vendor->kyc_status === 'pending' ? 'bg-yellow-500 text-white' : 
                               ($vendor->kyc_status === 'approved' ? 'bg-green-500 text-white' : 'bg-red-500 text-white') }}">
                            <i class="fas {{ $vendor->kyc_status === 'pending' ? 'fa-clock' : ($vendor->kyc_status === 'approved' ? 'fa-check-circle' : 'fa-times-circle') }} mr-1"></i>
                            {{ ucfirst($vendor->kyc_status) }}
                        </span>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="p-6">
                    <!-- Service Type Badge -->
                    <div class="mb-6 flex gap-2">
                        @if($vendor->offersProperties())
                            <span class="px-4 py-2 bg-blue-100 text-blue-800 rounded-lg font-semibold text-sm">
                                <i class="fas fa-home mr-2"></i>Property Rental
                            </span>
                        @endif
                        @if($vendor->offersCarRentals())
                            <span class="px-4 py-2 bg-primary/10 text-primary-dark rounded-lg font-semibold text-sm">
                                <i class="fas fa-car mr-2"></i>Car Rental
                            </span>
                        @endif
                    </div>

                    <div class="grid md:grid-cols-2 gap-6 mb-6">
                        <!-- Step 1: ID Information (Common for both) -->
                        <div class="bg-blue-50 border-2 border-blue-200 rounded-xl p-5">
                            <h4 class="font-bold text-lg mb-4 flex items-center text-blue-800">
                                <i class="fas fa-id-card text-blue-600 mr-2"></i>
                                Step 1: Identity Information
                            </h4>
                            <div class="space-y-3 text-sm">
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">ID Type</span>
                                    <p class="font-bold text-gray-800">{{ $vendor->id_card_type }}</p>
                                </div>
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">ID Number</span>
                                    <p class="font-bold text-gray-800">{{ $vendor->id_card_number }}</p>
                                </div>
                                @if($vendor->id_card_document)
                                    <a href="{{ asset('storage/' . $vendor->id_card_document) }}" target="_blank"
                                        class="block bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark transition font-semibold">
                                        <i class="fas fa-file-download mr-2"></i> View ID Document
                                    </a>
                                @endif
                            </div>
                        </div>

                        <!-- Step 2: Business Information (Property Vendors Only) -->
                        @if($vendor->offersProperties())
                        <div class="bg-green-50 border-2 border-green-200 rounded-xl p-5">
                            <h4 class="font-bold text-lg mb-4 flex items-center text-green-800">
                                <i class="fas fa-briefcase text-green-600 mr-2"></i>
                                Step 2: Business Information (Property)
                            </h4>
                            <div class="space-y-3 text-sm">
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">Business Address</span>
                                    <p class="font-semibold text-gray-800">{{ $vendor->business_address ?: 'N/A' }}</p>
                                </div>
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">Home Address</span>
                                    <p class="font-semibold text-gray-800">{{ $vendor->home_address ?: 'N/A' }}</p>
                                </div>
                                @if($vendor->cac_document)
                                    <a href="{{ asset('storage/' . $vendor->cac_document) }}" target="_blank"
                                        class="block bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark transition font-semibold">
                                        <i class="fas fa-file-download mr-2"></i> View CAC Document
                                    </a>
                                @endif
                            </div>
                        </div>
                        @endif

                        <!-- Step 3: Car Rental Information (Car Rental Vendors Only) -->
                        @if($vendor->offersCarRentals())
                        <div class="bg-primary/5 border-2 border-primary/20 rounded-xl p-5">
                            <h4 class="font-bold text-lg mb-4 flex items-center text-primary-dark">
                                <i class="fas fa-car text-primary mr-2"></i>
                                Step {{ $vendor->offersProperties() ? '3' : '2' }}: Car Rental Information
                            </h4>
                            <div class="space-y-3 text-sm">
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">Business Name</span>
                                    <p class="font-semibold text-gray-800">{{ $vendor->car_rental_business_name ?: 'N/A' }}</p>
                                </div>
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">CAC Registration Number</span>
                                    <p class="font-semibold text-gray-800">{{ $vendor->car_rental_business_registration ?: 'N/A' }}</p>
                                </div>
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">Tax ID (TIN)</span>
                                    <p class="font-semibold text-gray-800">{{ $vendor->car_rental_tax_id ?: 'N/A' }}</p>
                                </div>
                                <div class="bg-white rounded-lg p-3">
                                    <span class="text-gray-600 text-xs">Business Address</span>
                                    <p class="font-semibold text-gray-800">{{ $vendor->car_rental_business_address ?: 'N/A' }}</p>
                                </div>
                                
                                <!-- Bank Account Details -->
                                <div class="bg-blue-50 rounded-lg p-3 border border-blue-200">
                                    <span class="text-blue-800 text-xs font-bold flex items-center mb-2">
                                        <i class="fas fa-university mr-2"></i>Bank Account Details
                                    </span>
                                    <div class="grid grid-cols-3 gap-2 text-xs">
                                        <div>
                                            <span class="text-gray-500">Bank:</span>
                                            <p class="font-semibold text-gray-800">{{ $vendor->car_rental_bank_name ?: 'N/A' }}</p>
                                        </div>
                                        <div>
                                            <span class="text-gray-500">Account Number:</span>
                                            <p class="font-semibold text-gray-800">{{ $vendor->car_rental_account_number ?: 'N/A' }}</p>
                                        </div>
                                        <div>
                                            <span class="text-gray-500">Account Name:</span>
                                            <p class="font-semibold text-gray-800">{{ $vendor->car_rental_account_name ?: 'N/A' }}</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Car Rental Documents -->
                                <div class="grid grid-cols-1 gap-2 mt-3">
                                    @if($vendor->car_rental_business_certificate)
                                        <a href="{{ asset('storage/' . $vendor->car_rental_business_certificate) }}" target="_blank"
                                            class="block bg-primary text-white text-center py-2 rounded-lg hover:bg-primary-dark transition font-semibold text-xs">
                                            <i class="fas fa-file-pdf mr-2"></i> CAC Certificate
                                        </a>
                                    @endif
                                    @if($vendor->car_rental_license)
                                        <a href="{{ asset('storage/' . $vendor->car_rental_license) }}" target="_blank"
                                            class="block bg-primary text-white text-center py-2 rounded-lg hover:bg-primary-dark transition font-semibold text-xs">
                                            <i class="fas fa-file-pdf mr-2"></i> Transport/Rental License
                                        </a>
                                    @endif
                                    @if($vendor->car_rental_insurance_certificate)
                                        <a href="{{ asset('storage/' . $vendor->car_rental_insurance_certificate) }}" target="_blank"
                                            class="block bg-primary text-white text-center py-2 rounded-lg hover:bg-primary-dark transition font-semibold text-xs">
                                            <i class="fas fa-file-pdf mr-2"></i> Insurance Certificate
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Car Rental Business Verification Status -->
@if($vendor->offersCarRentals() && $vendor->car_rental_business_registration)
    <div class="mt-4 p-4 rounded-lg border-2
        {{ $vendor->car_rental_business_verified ? 'bg-green-50 border-green-300' : 'bg-yellow-50 border-yellow-300' }}">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <i class="fas {{ $vendor->car_rental_business_verified ? 'fa-check-circle text-green-600' : 'fa-exclamation-triangle text-yellow-600' }} text-2xl mr-3"></i>
                <div>
                    <p class="font-bold {{ $vendor->car_rental_business_verified ? 'text-green-800' : 'text-yellow-800' }}">
                        {{ $vendor->car_rental_business_verified ? 'Business Verified' : 'Business Not Verified' }}
                    </p>
                    @if($vendor->car_rental_business_verified && $vendor->car_rental_business_verified_at)
                        <p class="text-xs text-gray-600">
                            Verified on {{ $vendor->car_rental_business_verified_at->format('M d, Y H:i') }}
                        </p>
                    @endif
                </div>
            </div>
            
            @if(!$vendor->car_rental_business_verified && $vendor->kyc_status === 'pending')
                <form method="POST" action="{{ route('admin.kyc.verify-business', ['vendor' => $vendor, 'type' => 'car_rental']) }}" class="inline">
                    @csrf
                    <button type="submit" class="bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary-dark transition font-semibold">
                        <i class="fas fa-shield-alt mr-2"></i>Verify Business
                    </button>
                </form>
            @endif
        </div>
        
        @if($vendor->car_rental_verification_data)
            <div class="mt-3 pt-3 border-t border-gray-300">
                <p class="text-xs font-semibold text-gray-700 mb-2">Verification Details:</p>
                <div class="grid grid-cols-2 gap-2 text-xs">
                    <div>
                        <span class="text-gray-500">Registered Name:</span>
                        <p class="font-semibold">{{ $vendor->car_rental_verification_data['name'] ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <span class="text-gray-500">Company Status:</span>
                        <p class="font-semibold">{{ $vendor->car_rental_verification_data['companyStatus'] ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <span class="text-gray-500">Entity Type:</span>
                        <p class="font-semibold">{{ $vendor->car_rental_verification_data['typeOfEntity'] ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <span class="text-gray-500">Registration Date:</span>
                        <p class="font-semibold">{{ $vendor->car_rental_verification_data['registrationDate'] ?? 'N/A' }}</p>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endif

                    @if($vendor->kyc_rejection_reason)
                        <div class="bg-red-50 border-l-4 border-red-500 rounded-lg p-4 mb-6">
                            <div class="flex items-start">
                                <i class="fas fa-exclamation-circle text-red-500 text-xl mr-3 mt-1"></i>
                                <div>
                                    <p class="font-bold text-red-800 mb-1">Rejection Reason:</p>
                                    <p class="text-sm text-red-700">{{ $vendor->kyc_rejection_reason }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($vendor->kyc_status === 'pending')
                        <div class="flex gap-4 pt-4 border-t-2 border-gray-200">
                            <form method="POST" action="{{ route('admin.kyc.approve', $vendor) }}" class="flex-1">
                                @csrf
                                <button type="submit" 
                                    class="w-full bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-lg">
                                    <i class="fas fa-check-circle mr-2"></i> Approve KYC
                                </button>
                            </form>
                            
                            <button onclick="openRejectModal({{ $vendor->id }})" 
                                class="flex-1 bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-lg">
                                <i class="fas fa-times-circle mr-2"></i> Reject KYC
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        @empty
            <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-xl shadow-lg p-16 text-center border-2 border-dashed border-gray-300">
                <div class="bg-gray-200 rounded-full w-24 h-24 flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-inbox text-5xl text-gray-400"></i>
                </div>
                <h3 class="text-2xl font-bold text-gray-700 mb-2">No KYC Submissions Found</h3>
                <p class="text-gray-600">No vendors with <span class="font-semibold">{{ $status }}</span> status at the moment.</p>
            </div>
        @endforelse
    </div>

    <div class="mt-6">
        {{ $vendors->links() }}
    </div>
</div>

<!-- Reject Modal -->
<div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-60 backdrop-blur-sm flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl shadow-2xl max-w-lg w-full mx-4 transform transition-all">
        <!-- Modal Header -->
        <div class="bg-gradient-to-r from-red-500 to-red-600 text-white rounded-t-2xl p-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="bg-white/20 p-3 rounded-lg mr-3">
                        <i class="fas fa-times-circle text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold">Reject KYC</h2>
                        <p class="text-sm text-red-100">Provide a reason for rejection</p>
                    </div>
                </div>
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="text-white hover:bg-white/20 rounded-full p-2 transition">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
        </div>

        <!-- Modal Body -->
        <form id="reject-form" method="POST" class="p-6">
            @csrf
            
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-comment-alt text-red-600 mr-2"></i>Reason for Rejection *
                </label>
                <textarea name="kyc_rejection_reason" rows="5" required
                    placeholder="Please provide a detailed reason for rejecting this KYC submission..."
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-red-500 focus:outline-none transition"></textarea>
                <p class="text-xs text-gray-600 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>This reason will be shown to the vendor
                </p>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300 font-semibold transition">
                    <i class="fas fa-arrow-left mr-2"></i>Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold">
                    <i class="fas fa-ban mr-2"></i>Reject KYC
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openRejectModal(vendorId) {
    document.getElementById('reject-form').action = `/admin/kyc/${vendorId}/reject`;
    document.getElementById('reject-modal').classList.remove('hidden');
}
</script>
@endsection
