@extends('layouts.admin')

@section('title', 'KYC Form Builder')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800 mb-2">
                    <i class="fas fa-edit text-primary mr-3"></i>KYC Form Builder
                </h1>
                <p class="text-gray-600">Customize the KYC form fields that vendors see</p>
            </div>
            <a href="{{ route('admin.kyc-form.create') }}" class="bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark transition font-semibold">
                <i class="fas fa-plus mr-2"></i>Add New Field
            </a>
        </div>
    </div>

    <!-- Info Card -->
    <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-4 mb-6">
        <div class="flex items-start">
            <i class="fas fa-info-circle text-blue-500 text-xl mr-3 mt-1"></i>
            <div>
                <p class="font-semibold text-blue-800 mb-1">Drag & Drop to Reorder</p>
                <p class="text-sm text-blue-700">You can drag fields to change their order. Changes are saved automatically.</p>
            </div>
        </div>
    </div>

    <!-- Fields List -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <div class="p-6">
            <h3 class="text-xl font-bold text-gray-800 mb-4">Form Fields ({{ $fields->count() }})</h3>
            
            @if($fields->count() > 0)
                <div id="sortable-fields" class="space-y-3">
                    @foreach($fields as $field)
                        <div class="field-item bg-gray-50 border-2 border-gray-200 rounded-lg p-4 hover:border-primary transition cursor-move" data-id="{{ $field->id }}">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-4 flex-1">
                                    <div class="text-gray-400 hover:text-primary cursor-grab">
                                        <i class="fas fa-grip-vertical text-xl"></i>
                                    </div>
                                    
                                    <div class="flex-1">
                                        <div class="flex items-center gap-3 mb-2">
                                            <h4 class="font-bold text-gray-800">{{ $field->field_label }}</h4>
                                            
                                            @if($field->is_required)
                                                <span class="px-2 py-1 bg-red-100 text-red-800 rounded text-xs font-semibold">Required</span>
                                            @else
                                                <span class="px-2 py-1 bg-gray-200 text-gray-700 rounded text-xs font-semibold">Optional</span>
                                            @endif
                                            
                                            @if(!$field->is_active)
                                                <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded text-xs font-semibold">Inactive</span>
                                            @endif
                                            
                                            <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded text-xs font-semibold">
                                                <i class="fas fa-{{ $field->field_type === 'text' ? 'font' : ($field->field_type === 'textarea' ? 'align-left' : ($field->field_type === 'select' ? 'list' : ($field->field_type === 'file' ? 'file-upload' : ($field->field_type === 'email' ? 'envelope' : ($field->field_type === 'tel' ? 'phone' : 'hashtag'))))) }} mr-1"></i>
                                                {{ ucfirst($field->field_type) }}
                                            </span>
                                        </div>
                                        
                                        <div class="text-sm text-gray-600">
                                            <p><strong>Field Name:</strong> {{ $field->field_name }}</p>
                                            @if($field->placeholder)
                                                <p><strong>Placeholder:</strong> {{ $field->placeholder }}</p>
                                            @endif
                                            @if($field->help_text)
                                                <p><strong>Help Text:</strong> {{ $field->help_text }}</p>
                                            @endif
                                            @if($field->field_type === 'select' && $field->field_options)
                                                <p><strong>Options:</strong> {{ implode(', ', array_values($field->field_options)) }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="flex items-center gap-2 ml-4">
                                    <a href="{{ route('admin.kyc-form.edit', $field) }}" 
                                        class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition text-sm font-semibold">
                                        <i class="fas fa-edit mr-1"></i>Edit
                                    </a>
                                    
                                    <form method="POST" action="{{ route('admin.kyc-form.destroy', $field) }}" 
                                        onsubmit="return confirm('Are you sure you want to delete this field?');" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition text-sm font-semibold">
                                            <i class="fas fa-trash mr-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12">
                    <i class="fas fa-inbox text-6xl text-gray-300 mb-4"></i>
                    <h3 class="text-xl font-bold text-gray-700 mb-2">No Fields Yet</h3>
                    <p class="text-gray-600 mb-4">Start building your KYC form by adding fields.</p>
                    <a href="{{ route('admin.kyc-form.create') }}" class="inline-block bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark transition font-semibold">
                        <i class="fas fa-plus mr-2"></i>Add First Field
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sortableList = document.getElementById('sortable-fields');
        
        if (sortableList) {
            new Sortable(sortableList, {
                animation: 150,
                handle: '.cursor-grab',
                ghostClass: 'bg-primary-light',
                onEnd: function(evt) {
                    // Get new order
                    const items = sortableList.querySelectorAll('.field-item');
                    const order = Array.from(items).map(item => item.dataset.id);
                    
                    // Send to server
                    fetch('{{ route('admin.kyc-form.reorder') }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ order: order })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Show success message
                            console.log('Order updated successfully');
                        }
                    })
                    .catch(error => console.error('Error:', error));
                }
            });
        }
    });
</script>
@endpush
@endsection
