@extends('layouts.admin')

@section('title', 'Edit House Type Image')

@section('content')
<div class="px-4 py-8 max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center mb-4">
            <a href="{{ route('admin.house-types.index') }}" 
                class="text-gray-600 hover:text-gray-800 mr-4">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h1 class="text-3xl font-bold text-gray-800">
                <i class="fas fa-edit text-indigo-600 mr-3"></i>Edit House Type Image
            </h1>
        </div>
        <p class="text-gray-600">Update banner image for {{ $houseType->house_type }}</p>
    </div>

    <!-- Form -->
    <form method="POST" action="{{ route('admin.house-types.update', $houseType) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="bg-white rounded-xl shadow-lg p-8">
            <!-- House Type (Read-only) -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-tag text-indigo-600 mr-2"></i>House Type
                </label>
                <div class="w-full border-2 border-gray-200 rounded-lg px-4 py-3 bg-gray-50 text-gray-700 font-semibold">
                    {{ $houseType->house_type }}
                </div>
                <p class="text-sm text-gray-500 mt-1">House type cannot be changed</p>
            </div>

            <!-- Current Image -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-image text-indigo-600 mr-2"></i>Current Image
                </label>
                <div class="bg-gray-50 rounded-lg p-4 border-2 border-gray-200">
                    <img src="{{ asset('storage/' . $houseType->image) }}" 
                        alt="{{ $houseType->house_type }}" 
                        class="max-w-full h-64 object-cover rounded-lg mx-auto">
                </div>
            </div>

            <!-- New Image Upload -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-upload text-indigo-600 mr-2"></i>Upload New Image (Optional)
                </label>
                <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-indigo-600 transition">
                    <input type="file" 
                        name="image" 
                        id="imageInput"
                        accept="image/*"
                        class="hidden"
                        onchange="previewImage(event)">
                    <label for="imageInput" class="cursor-pointer">
                        <div id="imagePreview" class="mb-4">
                            <i class="fas fa-cloud-upload-alt text-6xl text-gray-400"></i>
                        </div>
                        <p class="text-gray-600 mb-2">Click to upload new banner image</p>
                        <p class="text-sm text-gray-500">Recommended: 800x600px, Max 5MB (JPG, PNG, WebP)</p>
                    </label>
                </div>
                @error('image')
                    <p class="text-red-500 text-sm mt-2">{{ $message }}</p>
                @enderror
            </div>

            <!-- Description -->
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-align-left text-indigo-600 mr-2"></i>Description (Optional)
                </label>
                <textarea name="description" 
                    rows="3" 
                    maxlength="500"
                    placeholder="Brief description of this house type..."
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-indigo-600 focus:outline-none transition @error('description') border-red-500 @enderror">{{ old('description', $houseType->description) }}</textarea>
                <p class="text-sm text-gray-500 mt-1">Maximum 500 characters</p>
                @error('description')
                    <p class="text-red-500 text-sm mt-2">{{ $message }}</p>
                @enderror
            </div>

            <!-- Active Status -->
            <div class="mb-6">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" 
                        name="active" 
                        value="1"
                        {{ old('active', $houseType->active) ? 'checked' : '' }}
                        class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                    <span class="ml-3 text-gray-700 font-semibold">
                        <i class="fas fa-eye text-indigo-600 mr-2"></i>Show on Homepage
                    </span>
                </label>
            </div>

            <!-- Property Count Info -->
            <div class="mb-6 bg-blue-50 border-l-4 border-blue-500 p-4 rounded-lg">
                <div class="flex items-center">
                    <i class="fas fa-info-circle text-blue-600 text-xl mr-3"></i>
                    <div>
                        <p class="text-blue-900 font-semibold">
                            {{ $houseType->property_count }} {{ $houseType->property_count == 1 ? 'property' : 'properties' }} 
                            of this type
                        </p>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="flex items-center justify-end space-x-4 pt-6 border-t">
                <a href="{{ route('admin.house-types.index') }}" 
                    class="px-6 py-3 border-2 border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 font-semibold transition">
                    Cancel
                </a>
                <button type="submit" 
                    class="px-8 py-3 bg-gradient-to-r from-indigo-600 to-indigo-800 text-white rounded-lg hover:shadow-lg font-semibold transition transform hover:scale-105">
                    <i class="fas fa-save mr-2"></i>Update House Type Image
                </button>
            </div>
        </div>
    </form>
</div>

<script>
function previewImage(event) {
    const preview = document.getElementById('imagePreview');
    const file = event.target.files[0];
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.innerHTML = `<img src="${e.target.result}" class="max-w-full h-64 object-cover rounded-lg mx-auto">`;
        }
        reader.readAsDataURL(file);
    }
}
</script>
@endsection
