@extends('layouts.admin')

@section('title', 'Edit FAQ')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <!-- Header -->
    <div class="mb-6">
        <a href="{{ route('admin.faqs.index') }}" class="text-primary hover:underline mb-2 inline-block">
            <i class="fas fa-arrow-left mr-2"></i>Back to FAQs
        </a>
        <h1 class="text-3xl font-bold text-secondary">Edit FAQ</h1>
        <p class="text-gray-600 mt-1">Update the frequently asked question</p>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded">
            <p class="font-bold mb-2">Please fix the following errors:</p>
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.faqs.update', $faq) }}" method="POST" class="bg-white rounded-lg shadow-md p-6">
        @csrf
        @method('PUT')

        <!-- Question -->
        <div class="mb-6">
            <label for="question" class="block text-sm font-medium text-gray-700 mb-2">
                Question <span class="text-red-500">*</span>
            </label>
            <input type="text" name="question" id="question" value="{{ old('question', $faq->question) }}" required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                placeholder="e.g., How do I book a property?">
        </div>

        <!-- Answer -->
        <div class="mb-6">
            <label for="answer" class="block text-sm font-medium text-gray-700 mb-2">
                Answer <span class="text-red-500">*</span>
            </label>
            <textarea name="answer" id="answer" rows="6" required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                placeholder="Provide a detailed answer...">{{ old('answer', $faq->answer) }}</textarea>
            <p class="text-xs text-gray-500 mt-1">You can use line breaks for better formatting</p>
        </div>

        <!-- Category -->
        <div class="mb-6">
            <label for="category" class="block text-sm font-medium text-gray-700 mb-2">
                Category <span class="text-red-500">*</span>
            </label>
            <select name="category" id="category" required
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent">
                @foreach($categories as $key => $label)
                    <option value="{{ $key }}" {{ old('category', $faq->category) == $key ? 'selected' : '' }}>
                        {{ $label }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Display Order -->
        <div class="mb-6">
            <label for="display_order" class="block text-sm font-medium text-gray-700 mb-2">
                Display Order
            </label>
            <input type="number" name="display_order" id="display_order" value="{{ old('display_order', $faq->display_order) }}" min="0"
                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent"
                placeholder="0">
            <p class="text-xs text-gray-500 mt-1">Lower numbers appear first (0 = highest priority)</p>
        </div>

        <!-- Is Active -->
        <div class="mb-6">
            <label class="flex items-center">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $faq->is_active) ? 'checked' : '' }}
                    class="w-4 h-4 text-primary border-gray-300 rounded focus:ring-primary">
                <span class="ml-2 text-sm text-gray-700">Active (visible on FAQ page)</span>
            </label>
        </div>

        <!-- Submit Buttons -->
        <div class="flex justify-end space-x-4 pt-6 border-t">
            <a href="{{ route('admin.faqs.index') }}" 
                class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">
                Cancel
            </a>
            <button type="submit" 
                class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark transition">
                <i class="fas fa-save mr-2"></i>Update FAQ
            </button>
        </div>
    </form>
</div>
@endsection
