@extends('layouts.admin')

@section('title', 'Car Details - ' . $car->full_name)

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">{{ $car->full_name }}</h1>
                    <p class="text-green-100">{{ $car->plate_number }} • {{ $car->category->name }}</p>
                </div>
                <a href="{{ route('admin.cars.index') }}" 
                    class="bg-white/20 backdrop-blur-sm text-white px-6 py-3 rounded-lg hover:bg-white/30 transition">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Cars
                </a>
            </div>
        </div>
    </div>

    <!-- Status Actions -->
    @if($car->status === 'pending')
        <div class="bg-yellow-50 border-2 border-yellow-200 rounded-xl p-6 mb-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="bg-yellow-500 text-white rounded-full p-3 mr-4">
                        <i class="fas fa-clock text-2xl"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-yellow-800">Pending Approval</h3>
                        <p class="text-yellow-700">This car is waiting for your review</p>
                    </div>
                </div>
                <div class="flex gap-3">
                    <form action="{{ route('admin.cars.approve', $car) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" 
                            class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold"
                            onclick="return confirm('Approve this car?')">
                            <i class="fas fa-check-circle mr-2"></i>Approve
                        </button>
                    </form>
                    
                    <button onclick="document.getElementById('reject-modal').classList.remove('hidden')"
                        class="bg-red-600 text-white px-6 py-3 rounded-lg hover:bg-red-700 transition font-semibold">
                        <i class="fas fa-times-circle mr-2"></i>Reject
                    </button>
                </div>
            </div>
        </div>
    @elseif($car->status === 'approved')
        <div class="bg-green-50 border-2 border-green-200 rounded-xl p-6 mb-6">
            <div class="flex items-center">
                <div class="bg-green-500 text-white rounded-full p-3 mr-4">
                    <i class="fas fa-check-circle text-2xl"></i>
                </div>
                <div>
                    <h3 class="text-xl font-bold text-green-800">Approved</h3>
                    <p class="text-green-700">This car is live and available for bookings</p>
                </div>
            </div>
        </div>
    @else
        <div class="bg-red-50 border-2 border-red-200 rounded-xl p-6 mb-6">
            <div class="flex items-start">
                <div class="bg-red-500 text-white rounded-full p-3 mr-4">
                    <i class="fas fa-times-circle text-2xl"></i>
                </div>
                <div class="flex-1">
                    <h3 class="text-xl font-bold text-red-800 mb-2">Rejected</h3>
                    @if($car->rejection_reason)
                        <div class="bg-white rounded-lg p-4">
                            <p class="text-sm text-gray-600 mb-1">Rejection Reason:</p>
                            <p class="text-red-700 font-semibold">{{ $car->rejection_reason }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endif

    <div class="grid lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Photos -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="bg-gray-800 text-white px-6 py-4">
                    <h2 class="text-xl font-bold flex items-center">
                        <i class="fas fa-images mr-3"></i>Photos
                    </h2>
                </div>
                <div class="p-6">
                    @if($car->photos && count($car->photos) > 0)
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                            @foreach($car->photos as $photo)
                                <img src="{{ asset('storage/' . $photo) }}" 
                                    alt="Car photo"
                                    class="w-full h-48 object-cover rounded-lg">
                            @endforeach
                        </div>
                    @else
                        <p class="text-gray-500 text-center py-8">No photos available</p>
                    @endif
                </div>
            </div>

            <!-- Basic Information -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                    <i class="fas fa-info-circle text-green-600 mr-3"></i>Basic Information
                </h2>
                <div class="grid md:grid-cols-2 gap-4">
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Brand</p>
                        <p class="font-bold text-gray-800">{{ $car->brand }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Model</p>
                        <p class="font-bold text-gray-800">{{ $car->model }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Year</p>
                        <p class="font-bold text-gray-800">{{ $car->year }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Color</p>
                        <p class="font-bold text-gray-800">{{ $car->color }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Plate Number</p>
                        <p class="font-bold text-gray-800">{{ $car->plate_number }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600 mb-1">Category</p>
                        <p class="font-bold text-gray-800">{{ $car->category->name }}</p>
                    </div>
                </div>
            </div>

            <!-- Specifications -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                    <i class="fas fa-cogs text-green-600 mr-3"></i>Specifications
                </h2>
                <div class="grid md:grid-cols-3 gap-4">
                    <div class="p-4 bg-gray-50 rounded-lg text-center">
                        <i class="fas fa-users text-green-600 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-600">Seats</p>
                        <p class="font-bold text-gray-800">{{ $car->seats }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg text-center">
                        <i class="fas fa-door-open text-green-600 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-600">Doors</p>
                        <p class="font-bold text-gray-800">{{ $car->doors }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg text-center">
                        <i class="fas fa-suitcase text-green-600 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-600">Luggage</p>
                        <p class="font-bold text-gray-800">{{ $car->luggage_capacity }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg text-center">
                        <i class="fas fa-cog text-green-600 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-600">Transmission</p>
                        <p class="font-bold text-gray-800">{{ ucfirst($car->transmission) }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg text-center">
                        <i class="fas fa-gas-pump text-green-600 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-600">Fuel Type</p>
                        <p class="font-bold text-gray-800">{{ ucfirst($car->fuel_type) }}</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-lg text-center">
                        <i class="fas fa-snowflake text-green-600 text-2xl mb-2"></i>
                        <p class="text-sm text-gray-600">A/C</p>
                        <p class="font-bold text-gray-800">{{ $car->air_conditioning ? 'Yes' : 'No' }}</p>
                    </div>
                </div>

                @if($car->features && count($car->features) > 0)
                    <div class="mt-6">
                        <p class="font-semibold text-gray-800 mb-3">Features:</p>
                        <div class="grid md:grid-cols-3 gap-2">
                            @foreach($car->features as $feature)
                                <div class="flex items-center p-2 bg-green-50 rounded">
                                    <i class="fas fa-check-circle text-green-600 mr-2"></i>
                                    <span class="text-sm text-gray-700">{{ $feature }}</span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            <!-- Description -->
            @if($car->description)
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-align-left text-green-600 mr-3"></i>Description
                    </h2>
                    <p class="text-gray-700 leading-relaxed">{{ $car->description }}</p>
                </div>
            @endif

            <!-- Bookings -->
            @if($car->bookings->count() > 0)
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                        <i class="fas fa-calendar-check text-green-600 mr-3"></i>
                        Bookings ({{ $car->bookings->count() }})
                    </h2>
                    <div class="space-y-3">
                        @foreach($car->bookings->take(5) as $booking)
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                <div>
                                    <p class="font-semibold text-gray-800">{{ $booking->booking_reference }}</p>
                                    <p class="text-sm text-gray-600">{{ $booking->driver_name }}</p>
                                    <p class="text-xs text-gray-500">{{ $booking->pickup_date->format('M d, Y') }}</p>
                                </div>
                                <span class="px-3 py-1 rounded-full text-xs font-semibold
                                    @if($booking->status === 'completed') bg-green-100 text-green-800
                                    @elseif($booking->status === 'active') bg-blue-100 text-blue-800
                                    @elseif($booking->status === 'cancelled') bg-red-100 text-red-800
                                    @else bg-yellow-100 text-yellow-800 @endif">
                                    {{ ucfirst($booking->status) }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1 space-y-6">
            <!-- Vendor Info -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-store text-green-600 mr-3"></i>Vendor
                </h2>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-gray-600">Company</p>
                        <p class="font-bold text-gray-800">{{ $car->vendor->company_name }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Email</p>
                        <p class="text-gray-800">{{ $car->vendor->user->email }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Phone</p>
                        <p class="text-gray-800">{{ $car->vendor->user->phone ?? 'N/A' }}</p>
                    </div>
                    <a href="{{ route('admin.vendors.show', $car->vendor) }}" 
                        class="block w-full bg-green-600 text-white text-center px-4 py-2 rounded-lg hover:bg-green-700 transition">
                        View Vendor Profile
                    </a>
                </div>
            </div>

            <!-- Pricing -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-money-bill-wave text-green-600 mr-3"></i>Pricing
                </h2>
                <div class="space-y-3">
                    <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                        <span class="text-gray-600">Per Day</span>
                        <span class="font-bold text-green-600">₦{{ number_format($car->price_per_day) }}</span>
                    </div>
                    @if($car->price_per_week)
                        <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                            <span class="text-gray-600">Per Week</span>
                            <span class="font-bold text-green-600">₦{{ number_format($car->price_per_week) }}</span>
                        </div>
                    @endif
                    @if($car->price_per_month)
                        <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                            <span class="text-gray-600">Per Month</span>
                            <span class="font-bold text-green-600">₦{{ number_format($car->price_per_month) }}</span>
                        </div>
                    @endif
                    <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                        <span class="text-gray-600">Security Deposit</span>
                        <span class="font-bold text-gray-800">₦{{ number_format($car->security_deposit) }}</span>
                    </div>
                </div>
            </div>

            <!-- Location -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-map-marker-alt text-green-600 mr-3"></i>Location
                </h2>
                <div class="space-y-2">
                    <p class="text-gray-700"><strong>City:</strong> {{ $car->city }}</p>
                    <p class="text-gray-700"><strong>State:</strong> {{ $car->state }}</p>
                    <p class="text-sm text-gray-600 mt-3">{{ $car->pickup_location }}</p>
                </div>
            </div>

            <!-- Requirements -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-user-check text-green-600 mr-3"></i>Requirements
                </h2>
                <div class="space-y-2 text-sm">
                    <p class="flex items-center text-gray-700">
                        <i class="fas fa-birthday-cake text-green-600 mr-2 w-5"></i>
                        Min. age: {{ $car->minimum_driver_age }} years
                    </p>
                    <p class="flex items-center text-gray-700">
                        <i class="fas fa-id-card text-green-600 mr-2 w-5"></i>
                        License: {{ $car->minimum_license_years }}+ years
                    </p>
                    <p class="flex items-center text-gray-700">
                        <i class="fas fa-calendar text-green-600 mr-2 w-5"></i>
                        Min. rental: {{ $car->minimum_rental_days }} days
                    </p>
                    @if($car->maximum_rental_days)
                        <p class="flex items-center text-gray-700">
                            <i class="fas fa-calendar-alt text-green-600 mr-2 w-5"></i>
                            Max. rental: {{ $car->maximum_rental_days }} days
                        </p>
                    @endif
                </div>
            </div>

            <!-- Statistics -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-chart-bar text-green-600 mr-3"></i>Statistics
                </h2>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Total Bookings</span>
                        <span class="font-bold text-gray-800">{{ $car->total_bookings }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Average Rating</span>
                        <span class="font-bold text-gray-800">
                            @if($car->average_rating > 0)
                                <i class="fas fa-star text-yellow-500"></i> {{ number_format($car->average_rating, 1) }}
                            @else
                                N/A
                            @endif
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Views</span>
                        <span class="font-bold text-gray-800">{{ number_format($car->views) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-xl shadow-2xl p-8 max-w-md w-full mx-4">
        <h3 class="text-2xl font-bold text-gray-800 mb-4">Reject Car</h3>
        <form action="{{ route('admin.cars.reject', $car) }}" method="POST">
            @csrf
            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Rejection Reason *</label>
                <textarea name="rejection_reason" rows="4" required
                    placeholder="Explain why this car is being rejected..."
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-red-600 focus:outline-none"></textarea>
            </div>
            <div class="flex gap-3">
                <button type="submit" 
                    class="flex-1 bg-red-600 text-white px-6 py-3 rounded-lg hover:bg-red-700 transition font-semibold">
                    <i class="fas fa-times-circle mr-2"></i>Reject Car
                </button>
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300 transition font-semibold">
                    Cancel
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
