@extends('layouts.admin')

@section('title', 'Car Management')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-car mr-3"></i>Car Management
                    </h1>
                    <p class="text-green-100">Manage and approve vendor cars</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                    <i class="fas fa-tasks text-4xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Total Cars</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['total'] }}</p>
                </div>
                <div class="bg-blue-100 p-4 rounded-lg">
                    <i class="fas fa-car text-blue-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-yellow-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Pending Approval</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['pending'] }}</p>
                </div>
                <div class="bg-yellow-100 p-4 rounded-lg">
                    <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Approved</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['approved'] }}</p>
                </div>
                <div class="bg-green-100 p-4 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-red-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Rejected</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $stats['rejected'] }}</p>
                </div>
                <div class="bg-red-100 p-4 rounded-lg">
                    <i class="fas fa-times-circle text-red-600 text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
        <form method="GET" action="{{ route('admin.cars.index') }}" class="flex flex-wrap gap-4">
            <div class="flex-1 min-w-[200px]">
                <input type="text" name="search" value="{{ request('search') }}" 
                    placeholder="Search by brand, model, or plate..."
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-2">
            </div>
            
            <select name="status" class="border-2 border-gray-300 rounded-lg px-4 py-2">
                <option value="">All Status</option>
                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
            </select>

            <select name="category" class="border-2 border-gray-300 rounded-lg px-4 py-2">
                <option value="">All Categories</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                @endforeach
            </select>

            <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 transition">
                <i class="fas fa-search mr-2"></i>Filter
            </button>
            
            <a href="{{ route('admin.cars.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition">
                <i class="fas fa-redo mr-2"></i>Reset
            </a>
        </form>
    </div>

    <!-- Cars Table -->
    @if($cars->count() > 0)
        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gradient-to-r from-green-600 to-teal-600 text-white">
                        <tr>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Car</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Vendor</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Category</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Location</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Price/Day</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Status</th>
                            <th class="px-6 py-4 text-center text-sm font-semibold">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($cars as $car)
                        <tr class="hover:bg-gray-50 transition">
                            <td class="px-6 py-4">
                                <div class="flex items-center">
                                    @if($car->main_photo)
                                        <img src="{{ asset('storage/' . $car->main_photo) }}" 
                                            class="w-16 h-16 rounded-lg object-cover mr-4" 
                                            alt="{{ $car->full_name }}">
                                    @else
                                        <div class="w-16 h-16 bg-gray-200 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-car text-gray-400 text-2xl"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <p class="font-bold text-gray-800">{{ $car->full_name }}</p>
                                        <p class="text-sm text-gray-600">{{ $car->plate_number }}</p>
                                        <p class="text-xs text-gray-500">{{ $car->year }}</p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-sm font-semibold text-gray-800">{{ $car->vendor->company_name }}</p>
                                <p class="text-xs text-gray-600">{{ $car->vendor->user->email }}</p>
                            </td>
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-gray-100 text-gray-800">
                                    <i class="fas {{ $car->category->icon }} mr-2"></i>
                                    {{ $car->category->name }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-sm text-gray-800">{{ $car->city }}</p>
                                <p class="text-xs text-gray-600">{{ $car->state }}</p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-lg font-bold text-green-600">₦{{ number_format($car->price_per_day) }}</p>
                            </td>
                            <td class="px-6 py-4">
                                @if($car->status === 'approved')
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-green-100 text-green-800">
                                        <i class="fas fa-check-circle mr-2"></i>Approved
                                    </span>
                                @elseif($car->status === 'pending')
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-2"></i>Pending
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-red-100 text-red-800">
                                        <i class="fas fa-times-circle mr-2"></i>Rejected
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-center space-x-2">
                                    <a href="{{ route('admin.cars.show', $car) }}" 
                                        class="bg-blue-500 text-white px-3 py-2 rounded-lg hover:bg-blue-600 transition text-sm">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    
                                    @if($car->status === 'pending')
                                        <form action="{{ route('admin.cars.approve', $car) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit" 
                                                class="bg-green-500 text-white px-3 py-2 rounded-lg hover:bg-green-600 transition text-sm"
                                                onclick="return confirm('Approve this car?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endif
                                    
                                    <form action="{{ route('admin.cars.destroy', $car) }}" method="POST" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="bg-red-500 text-white px-3 py-2 rounded-lg hover:bg-red-600 transition text-sm"
                                            onclick="return confirm('Delete this car? This action cannot be undone.')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 bg-gray-50">
                {{ $cars->links() }}
            </div>
        </div>
    @else
        <div class="bg-white rounded-xl shadow-lg p-12 text-center">
            <div class="bg-gray-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-car text-gray-400 text-4xl"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-800 mb-3">No Cars Found</h3>
            <p class="text-gray-600">No cars match your current filters</p>
        </div>
    @endif
</div>
@endsection
