@extends('layouts.admin')

@section('title', 'Booking Details #' . $booking->id)

@section('content')
<div class="mb-6">
    <a href="{{ route('admin.bookings.index') }}" class="text-primary hover:text-primary-dark font-semibold">
        <i class="fas fa-arrow-left mr-2"></i> Back to Bookings
    </a>
</div>

<!-- Header Card -->
<div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6 mb-6">
    <div class="flex justify-between items-start">
        <div>
            <h1 class="text-3xl font-bold mb-2">Booking #{{ $booking->id }}</h1>
            <p class="text-primary-light"><i class="fas fa-hashtag mr-2"></i>Reference: {{ $booking->payment_reference }}</p>
        </div>
        <div class="text-right">
            <span class="px-4 py-2 rounded-full font-semibold text-sm
                @if($booking->booking_status === 'confirmed') bg-green-500 text-white
                @elseif($booking->booking_status === 'pending') bg-yellow-400 text-gray-900
                @elseif($booking->booking_status === 'completed') bg-blue-500 text-white
                @else bg-gray-500 text-white
                @endif">
                <i class="fas fa-circle text-xs mr-1"></i> {{ ucfirst($booking->booking_status) }}
            </span>
        </div>
    </div>
</div>

<div class="grid md:grid-cols-3 gap-6 mb-6">
    <!-- Main Content -->
    <div class="md:col-span-2 space-y-6">
        <!-- Guest & Vendor Info -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-users text-primary mr-3"></i> People Involved
            </h2>
            <div class="grid md:grid-cols-2 gap-6">
                <div class="bg-blue-50 rounded-lg p-4">
                    <h3 class="font-bold text-primary mb-3 flex items-center">
                        <i class="fas fa-user-circle mr-2"></i> Guest Information
                    </h3>
                    <div class="space-y-2 text-sm">
                        <p><strong>Name:</strong> {{ $booking->user->name }}</p>
                        <p><strong>Email:</strong> {{ $booking->user->email }}</p>
                        <p><strong>Phone:</strong> {{ $booking->user->phone }}</p>
                    </div>
                </div>

                <div class="bg-green-50 rounded-lg p-4">
                    <h3 class="font-bold text-green-700 mb-3 flex items-center">
                        <i class="fas fa-store mr-2"></i> Vendor Information
                    </h3>
                    <div class="space-y-2 text-sm">
                        <p><strong>Company:</strong> {{ $booking->vendor->company_name }}</p>
                        <p><strong>Contact:</strong> {{ $booking->vendor->user->name }}</p>
                        <p><strong>Phone:</strong> {{ $booking->vendor->user->phone }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Property & Stay Details -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-home text-primary mr-3"></i> Property & Stay Details
            </h2>
            <div class="space-y-3">
                <div class="flex items-start">
                    <i class="fas fa-building text-primary mt-1 mr-3"></i>
                    <div>
                        <p class="font-semibold">{{ $booking->property->title }}</p>
                        <p class="text-sm text-gray-600">{{ $booking->property->address }}, {{ $booking->property->city }}</p>
                    </div>
                </div>
                
                <div class="grid md:grid-cols-2 gap-4 mt-4">
                    <div class="bg-primary/5 rounded-lg p-3">
                        <p class="text-xs text-gray-600">Check-in</p>
                        <p class="font-semibold text-primary"><i class="fas fa-calendar-check mr-2"></i>{{ $booking->start_date->format('M d, Y') }}</p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-3">
                        <p class="text-xs text-gray-600">Check-out</p>
                        <p class="font-semibold text-primary"><i class="fas fa-calendar-times mr-2"></i>{{ $booking->end_date->format('M d, Y') }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-3 gap-3 mt-4">
                    <div class="text-center bg-light-bg rounded-lg p-3">
                        <p class="text-2xl font-bold text-primary">{{ $booking->nights_count }}</p>
                        <p class="text-xs text-gray-600">Nights</p>
                    </div>
                    <div class="text-center bg-light-bg rounded-lg p-3">
                        <p class="text-2xl font-bold text-primary">{{ $booking->guest_count }}</p>
                        <p class="text-xs text-gray-600">Guests</p>
                    </div>
                    <div class="text-center bg-light-bg rounded-lg p-3">
                        <p class="text-sm font-bold text-primary">{{ ucfirst($booking->trip_type) }}</p>
                        <p class="text-xs text-gray-600">Trip Type</p>
                    </div>
                </div>
                
                <p class="text-sm text-gray-600 mt-2">
                    <i class="fas fa-users mr-2"></i>{{ $booking->adults_count }} adults, {{ $booking->children_count }} children
                </p>

                <!-- Check-In/Out Status -->
                @if($booking->checked_in_at || $booking->checked_out_at || $booking->booking_status === 'checked_in')
                    <div class="mt-4 pt-4 border-t">
                        <h3 class="font-semibold text-gray-800 mb-3">
                            <i class="fas fa-clipboard-check text-primary mr-2"></i>Check-In/Out Status
                        </h3>
                        <div class="grid md:grid-cols-2 gap-3">
                            @if($booking->checked_in_at || $booking->booking_status === 'checked_in')
                                <div class="bg-green-50 border-l-4 border-green-500 p-3 rounded">
                                    <p class="font-semibold text-green-800 text-sm mb-1">
                                        <i class="fas fa-check-circle mr-1"></i>Checked In
                                    </p>
                                    <p class="text-xs text-green-700">
                                        {{ $booking->checked_in_at ? $booking->checked_in_at->format('M d, Y h:i A') : 'Status: Confirmed' }}
                                    </p>
                                </div>
                            @else
                                <div class="bg-gray-50 border-l-4 border-gray-300 p-3 rounded">
                                    <p class="font-semibold text-gray-600 text-sm">
                                        <i class="fas fa-clock mr-1"></i>Not Checked In
                                    </p>
                                </div>
                            @endif

                            @if($booking->checked_out_at)
                                <div class="bg-blue-50 border-l-4 border-blue-500 p-3 rounded">
                                    <p class="font-semibold text-blue-800 text-sm mb-1">
                                        <i class="fas fa-check-circle mr-1"></i>Checked Out
                                    </p>
                                    <p class="text-xs text-blue-700">
                                        {{ $booking->checked_out_at->format('M d, Y h:i A') }}
                                    </p>
                                </div>
                            @else
                                <div class="bg-gray-50 border-l-4 border-gray-300 p-3 rounded">
                                    <p class="font-semibold text-gray-600 text-sm">
                                        <i class="fas fa-clock mr-1"></i>Not Checked Out
                                    </p>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Payment Details -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-wallet text-primary mr-3"></i> Payment Details
            </h2>
            <div class="space-y-2">
                <div class="flex justify-between">
                    <span>Subtotal (Room charges)</span>
                    <span>₦{{ number_format($booking->subtotal) }}</span>
                </div>
                <div class="flex justify-between text-gray-600">
                    <span>Caution Fee (Refundable deposit)</span>
                    <span>₦{{ number_format($booking->caution_fee_amount) }}</span>
                </div>
                @if($booking->discount_amount > 0)
                    <div class="flex justify-between text-green-600 bg-green-50 -mx-4 px-4 py-2 rounded">
                        <span class="flex items-center">
                            <i class="fas fa-tag mr-2"></i>
                            Discount Applied <span class="text-xs ml-1 font-mono">({{ $booking->discount_code }})</span>
                        </span>
                        <span class="font-semibold">-₦{{ number_format($booking->discount_amount) }}</span>
                    </div>
                @endif
                <div class="flex justify-between font-bold text-lg border-t pt-2">
                    <span>Total Paid by Customer</span>
                    <span>₦{{ number_format($booking->total_amount) }}</span>
                </div>
                
                <div class="border-t pt-3 mt-3">
                    <p class="text-xs text-gray-600 mb-2">Commission breakdown (calculated on subtotal only):</p>
                    <div class="flex justify-between text-sm bg-primary/5 p-2 rounded">
                        <span>Platform Commission ({{ $booking->commission_rate }}% of ₦{{ number_format($booking->subtotal) }})</span>
                        <span class="font-semibold">₦{{ number_format($booking->commission_amount) }}</span>
                    </div>
                    <div class="flex justify-between text-sm bg-green-50 p-2 rounded mt-1">
                        <span>Vendor Payout (Subtotal - Commission)</span>
                        <span class="font-semibold">₦{{ number_format($booking->vendor_payout_amount) }}</span>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">
                        <i class="fas fa-info-circle"></i> Caution fee (₦{{ number_format($booking->caution_fee_amount) }}) is excluded from commission and will be refunded to vendor or customer based on property condition.
                    </p>
                </div>
            </div>

            <div class="mt-6 p-4 bg-gradient-to-r from-light-bg to-white rounded-lg border-l-4 border-primary">
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Payment Status</p>
                        <p class="font-bold text-lg {{ $booking->payment_status === 'paid' ? 'text-green-600' : 'text-yellow-600' }}">
                            <i class="fas fa-circle text-xs mr-1"></i> {{ ucfirst($booking->payment_status) }}
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Payment Method</p>
                        <p class="font-bold text-lg text-secondary">{{ $booking->payment_method ? ucfirst($booking->payment_method) : 'N/A' }}</p>
                    </div>
                </div>
                @if($booking->paid_at)
                    <div class="mt-3 pt-3 border-t">
                        <p class="text-sm text-gray-600">Paid At: <span class="font-semibold text-secondary">{{ $booking->paid_at->format('M d, Y H:i') }}</span></p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Admin Actions -->
        @if($booking->payment_status === 'paid' && !$booking->admin_verified)
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4 mb-4">
                    <p class="text-yellow-800 font-bold mb-2 flex items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i> Verification Required
                    </p>
                    <p class="text-sm text-yellow-700">This booking payment requires admin verification before details are unlocked.</p>
                </div>

                <form method="POST" action="{{ route('admin.bookings.verify', $booking) }}">
                    @csrf
                    <button type="submit" 
                        class="w-full bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                        <i class="fas fa-check-circle mr-2"></i> Verify Payment
                    </button>
                </form>
            </div>
        @endif

        @if($booking->admin_verified)
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                    <p class="text-green-800 font-bold flex items-center mb-2">
                        <i class="fas fa-check-circle mr-2"></i> Verified
                    </p>
                    <div class="text-sm text-green-700">
                        @if($booking->verifiedBy)
                            <p>By: <span class="font-semibold">{{ $booking->verifiedBy->name }}</span></p>
                        @endif
                        @if($booking->verified_at)
                            <p>On: {{ $booking->verified_at->format('M d, Y H:i') }}</p>
                        @elseif($booking->admin_verified_at)
                            <p>On: {{ $booking->admin_verified_at->format('M d, Y H:i') }}</p>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        <!-- Booking Timeline -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="font-bold text-lg text-gray-800 mb-4">
                <i class="fas fa-clock text-primary mr-2"></i>Booking Timeline
            </h3>
            
            <div class="space-y-4">
                <!-- Booking Created -->
                <div class="flex items-start">
                    <div class="bg-green-100 rounded-full p-2 mr-3">
                        <i class="fas fa-plus text-green-600"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-sm">Booking Created</p>
                        <p class="text-xs text-gray-600">{{ $booking->created_at->format('M d, Y h:i A') }}</p>
                    </div>
                </div>
                
                <!-- Vendor Approval -->
                @if($booking->requires_vendor_approval && $booking->vendor_approved_at)
                    <div class="flex items-start">
                        <div class="bg-teal-100 rounded-full p-2 mr-3">
                            <i class="fas fa-thumbs-up text-teal-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Vendor Approved</p>
                            <p class="text-xs text-gray-600">{{ $booking->vendor_approved_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                @endif
                
                <!-- Payment Received -->
                @if($booking->paid_at)
                    <div class="flex items-start">
                        <div class="bg-green-100 rounded-full p-2 mr-3">
                            <i class="fas fa-money-bill text-green-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Payment Received</p>
                            <p class="text-xs text-gray-600">{{ $booking->paid_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                @endif
                
                <!-- Admin Verified -->
                @if($booking->admin_verified && ($booking->verified_at || $booking->admin_verified_at))
                    <div class="flex items-start">
                        <div class="bg-blue-100 rounded-full p-2 mr-3">
                            <i class="fas fa-check-circle text-blue-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Admin Verified</p>
                            <p class="text-xs text-gray-600">
                                {{ ($booking->verified_at ?? $booking->admin_verified_at)->format('M d, Y h:i A') }}
                            </p>
                        </div>
                    </div>
                @endif
                
                <!-- Check-In -->
                @if($booking->checked_in_at)
                    <div class="flex items-start">
                        <div class="bg-purple-100 rounded-full p-2 mr-3">
                            <i class="fas fa-door-open text-purple-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Guest Checked In</p>
                            <p class="text-xs text-gray-600">{{ $booking->checked_in_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                @endif
                
                <!-- Check-Out -->
                @if($booking->checked_out_at)
                    <div class="flex items-start">
                        <div class="bg-gray-100 rounded-full p-2 mr-3">
                            <i class="fas fa-door-closed text-gray-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Guest Checked Out</p>
                            <p class="text-xs text-gray-600">{{ $booking->checked_out_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                @endif

                <!-- Completed -->
                @if($booking->booking_status === 'completed')
                    <div class="flex items-start">
                        <div class="bg-green-100 rounded-full p-2 mr-3">
                            <i class="fas fa-flag-checkered text-green-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Booking Completed</p>
                            <p class="text-xs text-gray-600">{{ $booking->updated_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                @endif

                <!-- Cancelled -->
                @if($booking->booking_status === 'cancelled' && $booking->cancelled_at)
                    <div class="flex items-start">
                        <div class="bg-red-100 rounded-full p-2 mr-3">
                            <i class="fas fa-times-circle text-red-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Booking Cancelled</p>
                            <p class="text-xs text-gray-600">{{ $booking->cancelled_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Caution Fee Management (Full Width) -->
<div class="mt-6">

    @if($booking->booking_status === 'completed' && $booking->checked_out_at)
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-shield-alt text-primary mr-3"></i> Caution Fee Management
            </h2>
            
            <!-- Current Status -->
            <div class="mb-6 p-4 bg-light-bg rounded-lg">
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Caution Fee Amount</p>
                        <p class="font-bold text-2xl text-gray-800">₦{{ number_format($booking->caution_fee_amount ?? 0) }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Current Status</p>
                        <p class="font-bold text-xl
                            @if($booking->caution_refund_status === 'refunded') text-green-600
                            @elseif($booking->caution_refund_status === 'deducted' || $booking->caution_refund_status === 'partially_deducted') text-orange-600
                            @elseif($booking->caution_refund_status === 'pending_vendor') text-yellow-600
                            @else text-gray-600
                            @endif">
                            <i class="fas fa-circle text-xs mr-1"></i> {{ ucfirst(str_replace('_', ' ', $booking->caution_refund_status ?? 'pending')) }}
                        </p>
                    </div>
                </div>
            </div>

            <!-- Caution Fee Dispute Resolution -->
            @if($booking->caution_refund_status === 'pending_vendor' && $booking->caution_deduction_amount)
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-exclamation-triangle text-red-600 mr-2"></i>Caution Fee Dispute
                    </h3>

                    <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
                        <p class="font-semibold text-red-800 mb-2">Vendor has reported damage</p>
                        <p class="text-sm text-red-700">
                            The vendor is requesting to deduct ₦{{ number_format($booking->caution_deduction_amount) }} 
                            from the caution fee of ₦{{ number_format($booking->caution_fee_amount ?? $booking->caution_fee ?? 0) }}.
                        </p>
                    </div>

                    <div class="mb-6">
                        <h4 class="font-bold text-gray-800 mb-2">Damage Report:</h4>
                        <p class="text-gray-700 bg-gray-50 p-4 rounded-lg">{{ $booking->caution_deduction_reason }}</p>
                    </div>

                    @if($booking->caution_deduction_photos)
                        <div class="mb-6">
                            <h4 class="font-bold text-gray-800 mb-2">Damage Photos:</h4>
                            <div class="grid grid-cols-3 gap-4">
                                @foreach(json_decode($booking->caution_deduction_photos) as $photo)
                                    <img src="{{ asset('storage/' . $photo) }}" 
                                        alt="Damage photo" 
                                        class="w-full h-32 object-cover rounded-lg cursor-pointer hover:opacity-75"
                                        onclick="window.open('{{ asset('storage/' . $photo) }}', '_blank')">
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('admin.bookings.resolve-caution', $booking) }}">
                        @csrf
                        
                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Admin Decision
                            </label>
                            <select name="decision" id="cautionDecision" required class="w-full border-gray-300 rounded-lg">
                                <option value="">Select decision...</option>
                                <option value="approve_deduction">Approve Deduction - Release to Vendor</option>
                                <option value="partial_deduction">Approve Partial Deduction</option>
                                <option value="reject_deduction">Reject Deduction - Refund to Customer</option>
                            </select>
                        </div>

                        <div id="partialAmountField" class="mb-4 hidden">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Approved Deduction Amount (₦)
                            </label>
                            <input type="number" name="approved_amount" 
                                min="0" max="{{ $booking->caution_fee_amount ?? $booking->caution_fee ?? 0 }}"
                                class="w-full border-gray-300 rounded-lg"
                                placeholder="Enter approved amount">
                        </div>

                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Admin Notes
                            </label>
                            <textarea name="admin_notes" rows="3" required
                                class="w-full border-gray-300 rounded-lg"
                                placeholder="Explain your decision..."></textarea>
                        </div>

                        <button type="submit" 
                            class="w-full bg-primary text-white py-3 rounded-lg hover:bg-primary-dark font-semibold transition">
                            <i class="fas fa-gavel mr-2"></i>Submit Decision
                        </button>
                    </form>

                    <script>
                        document.getElementById('cautionDecision').addEventListener('change', function() {
                            const partialAmount = document.getElementById('partialAmountField');
                            if (this.value === 'partial_deduction') {
                                partialAmount.classList.remove('hidden');
                                partialAmount.querySelector('input').required = true;
                            } else {
                                partialAmount.classList.add('hidden');
                                partialAmount.querySelector('input').required = false;
                            }
                        });
                    </script>
                </div>
            @elseif(!$booking->caution_refund_status || $booking->caution_refund_status === 'pending')
                <div class="p-4 bg-blue-50 border-l-4 border-blue-500 rounded">
                    <p class="text-blue-800">
                        <i class="fas fa-info-circle mr-2"></i>
                        Waiting for vendor to decide on caution fee refund. Vendor can either refund in full or report damages.
                    </p>
                </div>
            @endif

            <!-- User Refund Payout Request -->
            @if($booking->refund_payout_status === 'requested' && $booking->caution_refund_amount > 0)
                <div class="mt-6 bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-hand-holding-usd text-green-600 mr-2"></i>User Refund Payout Request
                    </h3>

                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 mb-6">
                        <p class="font-semibold text-yellow-800 mb-2">Action Required - User Requesting Refund</p>
                        <p class="text-sm text-yellow-700">
                            The user has requested payout of their caution fee refund of ₦{{ number_format($booking->caution_refund_amount) }}.
                        </p>
                        <p class="text-xs text-yellow-600 mt-2">
                            Requested on: {{ $booking->refund_requested_at->format('M d, Y h:i A') }}
                        </p>
                    </div>

                    <!-- User Bank Details -->
                    <div class="mb-6 bg-gray-50 rounded-lg p-4">
                        <h4 class="font-bold text-gray-800 mb-3">User Bank Details:</h4>
                        @if($booking->user->bank_name && $booking->user->account_number)
                            <div class="grid md:grid-cols-3 gap-4">
                                <div>
                                    <p class="text-xs text-gray-600">Bank Name</p>
                                    <p class="font-semibold">{{ $booking->user->bank_name }}</p>
                                </div>
                                <div>
                                    <p class="text-xs text-gray-600">Account Number</p>
                                    <p class="font-semibold">{{ $booking->user->account_number }}</p>
                                </div>
                                <div>
                                    <p class="text-xs text-gray-600">Account Name</p>
                                    <p class="font-semibold">{{ $booking->user->account_name ?? 'N/A' }}</p>
                                </div>
                            </div>
                        @else
                            <p class="text-red-600 text-sm">
                                <i class="fas fa-exclamation-triangle mr-2"></i>User has not provided bank details. Please contact user.
                            </p>
                        @endif
                    </div>

                    <!-- Process Refund Form -->
                    <form method="POST" action="{{ route('admin.bookings.process-refund', $booking) }}">
                        @csrf
                        
                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Payment Method
                            </label>
                            <select name="payment_method" required class="w-full border-gray-300 rounded-lg">
                                <option value="">Select payment method...</option>
                                <option value="bank_transfer">Bank Transfer</option>
                                <option value="cash">Cash</option>
                                <option value="cheque">Cheque</option>
                                <option value="mobile_money">Mobile Money</option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Payment Reference/Notes
                            </label>
                            <textarea name="payment_details" rows="3" required
                                class="w-full border-gray-300 rounded-lg"
                                placeholder="Enter transaction reference or payment notes..."></textarea>
                        </div>

                        <button type="submit" 
                            class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                            <i class="fas fa-check-circle mr-2"></i>Mark as Paid (₦{{ number_format($booking->caution_refund_amount) }})
                        </button>
                    </form>
                </div>
            @elseif($booking->refund_payout_status === 'processing')
                <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-500 rounded">
                    <p class="text-yellow-800">
                        <i class="fas fa-spinner fa-spin mr-2"></i>
                        Refund is being processed. Mark as paid when complete.
                    </p>
                </div>
            @elseif($booking->refund_payout_status === 'paid')
                <div class="mt-6 bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                    <p class="font-semibold text-green-800 mb-2">
                        <i class="fas fa-check-circle mr-2"></i>Refund Paid
                    </p>
                    <div class="grid md:grid-cols-2 gap-4 mt-3 text-sm">
                        <div>
                            <p class="text-gray-600">Amount Paid</p>
                            <p class="font-bold">₦{{ number_format($booking->caution_refund_amount) }}</p>
                        </div>
                        <div>
                            <p class="text-gray-600">Payment Date</p>
                            <p class="font-bold">{{ $booking->refund_paid_at->format('M d, Y h:i A') }}</p>
                        </div>
                        @if($booking->refund_payment_method)
                            <div>
                                <p class="text-gray-600">Payment Method</p>
                                <p class="font-bold">{{ ucfirst(str_replace('_', ' ', $booking->refund_payment_method)) }}</p>
                            </div>
                        @endif
                        @if($booking->refund_payment_details)
                            <div class="md:col-span-2">
                                <p class="text-gray-600">Payment Details</p>
                                <p class="font-bold">{{ $booking->refund_payment_details }}</p>
                            </div>
                        @endif
                    </div>
                </div>
            @endif

            <!-- Caution Refund Logs -->
            @if($booking->cautionRefundLogs->count() > 0)
                <div class="mt-6">
                    <h3 class="font-semibold text-lg mb-4 flex items-center">
                        <i class="fas fa-history text-primary mr-2"></i> Refund History
                    </h3>
                    <div class="space-y-3">
                        @foreach($booking->cautionRefundLogs as $log)
                            <div class="bg-light-bg border-l-4 border-primary p-4 rounded-lg">
                                <p class="font-semibold text-secondary">{{ $log->actor->name }} <span class="text-sm text-gray-600">({{ $log->actor_role }})</span></p>
                                <p class="text-sm text-gray-700 mt-1">{{ $log->action }}</p>
                                <p class="text-sm text-primary font-semibold mt-1">{{ $log->previous_status }} → {{ $log->new_status }}</p>
                                @if($log->reason)
                                    <p class="text-sm text-gray-600 mt-2 italic">"{{ $log->reason }}"</p>
                                @endif
                                <p class="text-xs text-gray-500 mt-2"><i class="fas fa-clock mr-1"></i>{{ $log->created_at->format('M d, Y H:i') }}</p>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    @endif
</div>

<!-- Activity Log -->
@if($booking->activities && $booking->activities->count() > 0)
    <div class="mt-6">
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-history text-primary mr-3"></i> Activity Log
            </h2>
            
            <div class="space-y-3">
                @foreach($booking->activities->sortByDesc('created_at') as $activity)
                    <div class="border-l-4 p-4 rounded
                        @if($activity->action === 'user_checkin') border-green-500 bg-green-50
                        @elseif($activity->action === 'user_checkout') border-blue-500 bg-blue-50
                        @elseif($activity->action === 'payment_verified') border-purple-500 bg-purple-50
                        @elseif($activity->action === 'booking_approved') border-teal-500 bg-teal-50
                        @else border-gray-500 bg-gray-50
                        @endif">
                        
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-2">
                                    @if($activity->action === 'user_checkin')
                                        <i class="fas fa-door-open text-green-600 text-lg"></i>
                                        <h3 class="font-semibold text-green-800">User Check-In</h3>
                                    @elseif($activity->action === 'user_checkout')
                                        <i class="fas fa-door-closed text-blue-600 text-lg"></i>
                                        <h3 class="font-semibold text-blue-800">User Check-Out</h3>
                                    @elseif($activity->action === 'payment_verified')
                                        <i class="fas fa-check-circle text-purple-600 text-lg"></i>
                                        <h3 class="font-semibold text-purple-800">Payment Verified</h3>
                                    @elseif($activity->action === 'booking_approved')
                                        <i class="fas fa-thumbs-up text-teal-600 text-lg"></i>
                                        <h3 class="font-semibold text-teal-800">Booking Approved</h3>
                                    @else
                                        <i class="fas fa-info-circle text-gray-600 text-lg"></i>
                                        <h3 class="font-semibold text-gray-800">{{ ucfirst(str_replace('_', ' ', $activity->action)) }}</h3>
                                    @endif
                                </div>
                                
                                <p class="text-sm text-gray-700 mb-2">{{ $activity->description }}</p>
                                
                                @if($activity->data)
                                    <div class="text-xs text-gray-600 space-y-1 mt-2">
                                        @php $data = is_string($activity->data) ? json_decode($activity->data, true) : $activity->data; @endphp
                                        @if(isset($data['user_name']))
                                            <p><i class="fas fa-user mr-1"></i><strong>User:</strong> {{ $data['user_name'] }}</p>
                                        @endif
                                        @if(isset($data['property']))
                                            <p><i class="fas fa-home mr-1"></i><strong>Property:</strong> {{ $data['property'] }}</p>
                                        @endif
                                        @if(isset($data['checked_in_at']))
                                            <p><i class="fas fa-clock mr-1"></i><strong>Checked In:</strong> {{ \Carbon\Carbon::parse($data['checked_in_at'])->format('M d, Y h:i A') }}</p>
                                        @endif
                                        @if(isset($data['checked_out_at']))
                                            <p><i class="fas fa-clock mr-1"></i><strong>Checked Out:</strong> {{ \Carbon\Carbon::parse($data['checked_out_at'])->format('M d, Y h:i A') }}</p>
                                        @endif
                                        @if(isset($data['stay_duration']))
                                            <p><i class="fas fa-calendar mr-1"></i><strong>Duration:</strong> {{ $data['stay_duration'] }}</p>
                                        @endif
                                    </div>
                                @endif
                            </div>
                            
                            <div class="text-right ml-4">
                                <p class="text-xs text-gray-500">
                                    <i class="fas fa-calendar-alt mr-1"></i>{{ $activity->created_at->format('M d, Y') }}
                                </p>
                                <p class="text-xs text-gray-500">
                                    <i class="fas fa-clock mr-1"></i>{{ $activity->created_at->format('h:i A') }}
                                </p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endif
@endsection
