@extends('layouts.admin')

@section('title', 'Advertisement Approvals')

@section('content')
<div>
    <h1 class="text-3xl font-bold mb-6">Advertisement Approvals</h1>

    <!-- Pending Payment Verification (Bank Transfer) -->
    @if(isset($pendingPaymentAds) && $pendingPaymentAds->count() > 0)
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="font-bold text-xl">Pending Payment Verification</h2>
            <span class="bg-orange-100 text-orange-800 px-3 py-1 rounded-full text-sm font-semibold">
                {{ $pendingPaymentAds->count() }}
            </span>
        </div>

        @foreach($pendingPaymentAds as $ad)
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <h3 class="font-bold">{{ $ad->property->title }}</h3>
                        <p class="text-sm text-gray-600">Vendor: {{ $ad->vendor->company_name }}</p>
                        <p class="text-sm text-gray-600">Plan: {{ $ad->adPlan->name }} ({{ $ad->adPlan->duration_days }} days)</p>
                        <p class="text-sm text-gray-600">Amount: ₦{{ number_format($ad->adPlan->price) }}</p>
                        <p class="text-sm text-gray-600">Payment Method: {{ ucfirst(str_replace('_', ' ', $ad->payment_method)) }}</p>
                        @if($ad->payment_proof)
                            <div class="mt-2">
                                <a href="{{ asset('storage/' . $ad->payment_proof) }}" target="_blank" 
                                    class="text-primary hover:underline text-sm">
                                    <i class="fas fa-image mr-1"></i> View Payment Proof
                                </a>
                            </div>
                        @endif
                    </div>

                    <div class="flex gap-2">
                        <form method="POST" action="{{ route('admin.ads.verify-payment', $ad) }}">
                            @csrf
                            <button type="submit" 
                                class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                <i class="fas fa-check mr-1"></i> Verify Payment
                            </button>
                        </form>

                        <form method="POST" action="{{ route('admin.ads.reject-payment', $ad) }}">
                            @csrf
                            <button type="submit" 
                                class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm"
                                onclick="return confirm('Reject this payment proof?')">
                                <i class="fas fa-times mr-1"></i> Reject
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
    @endif

    <!-- Pending Approvals -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="font-bold text-xl">Pending Approvals</h2>
            <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-semibold">
                {{ $pendingAds->count() }}
            </span>
        </div>

        @forelse($pendingAds as $ad)
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <h3 class="font-bold">{{ $ad->property->title }}</h3>
                        <p class="text-sm text-gray-600">Vendor: {{ $ad->vendor->company_name }}</p>
                        <p class="text-sm text-gray-600">Plan: {{ $ad->adPlan->name }} ({{ $ad->adPlan->duration_days }} days)</p>
                        <div class="text-sm text-gray-600">
                            @if($ad->discount_amount > 0)
                                <span class="line-through text-gray-400">₦{{ number_format($ad->adPlan->price) }}</span>
                                <span class="text-green-600 font-semibold ml-2">₦{{ number_format($ad->final_amount) }}</span>
                                <span class="ml-2 bg-green-100 text-green-700 px-2 py-0.5 rounded text-xs">
                                    <i class="fas fa-tag"></i> {{ $ad->promo_code }}
                                </span>
                            @else
                                Price: ₦{{ number_format($ad->adPlan->price) }}
                            @endif
                        </div>
                        @if($ad->paid_at)
                            <p class="text-xs text-green-600 mt-1">✓ Paid on {{ $ad->paid_at->format('M d, Y H:i') }}</p>
                        @endif
                    </div>

                    <div class="flex gap-2">
                        <form method="POST" action="{{ route('admin.ads.approve', $ad) }}">
                            @csrf
                            <button type="submit" 
                                class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                Approve
                            </button>
                        </form>

                        <form method="POST" action="{{ route('admin.ads.deactivate', $ad) }}">
                            @csrf
                            <button type="submit" 
                                class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm">
                                Reject
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        @empty
            <p class="text-gray-600 text-center py-8">No pending ad approvals</p>
        @endforelse
    </div>

    <!-- Active Ads -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="font-bold text-xl mb-4">Active Advertisements</h2>

        @forelse($activeAds as $ad)
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <h3 class="font-bold">{{ $ad->property->title }}</h3>
                        <p class="text-sm text-gray-600">Vendor: {{ $ad->vendor->company_name }}</p>
                        <p class="text-sm text-gray-600">Plan: {{ $ad->adPlan->name }}</p>
                        <p class="text-sm text-gray-600">
                            Active: {{ $ad->start_date->format('M d') }} - {{ $ad->end_date->format('M d, Y') }}
                        </p>
                        <p class="text-xs text-gray-500 mt-1">
                            {{ $ad->end_date->diffInDays(now()) }} days remaining
                        </p>
                    </div>

                    <div class="flex gap-2">
                        <button onclick="document.getElementById('extend-form-{{ $ad->id }}').classList.toggle('hidden')"
                            class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark text-sm">
                            Extend
                        </button>

                        <form method="POST" action="{{ route('admin.ads.deactivate', $ad) }}">
                            @csrf
                            <button type="submit" 
                                class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 text-sm">
                                Deactivate
                            </button>
                        </form>
                    </div>
                </div>

                <form id="extend-form-{{ $ad->id }}" 
                    method="POST" 
                    action="{{ route('admin.ads.extend', $ad) }}" 
                    class="hidden mt-3 flex gap-2">
                    @csrf
                    <input type="number" name="days" min="1" max="90" placeholder="Days" 
                        class="border rounded px-4 py-2 w-32">
                    <button type="submit" class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                        Extend
                    </button>
                </form>
            </div>
        @empty
            <p class="text-gray-600 text-center py-8">No active advertisements</p>
        @endforelse
    </div>
</div>
@endsection