<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions
        $permissions = [
            'manage-users',
            'manage-vendors',
            'manage-bookings',
            'manage-properties',
            'manage-reviews',
            'manage-ads',
            'manage-payouts',
            'manage-settings',
            'manage-roles',
            'view-audit-logs',
            'verify-payments',
            'approve-bookings',
            'approve-ads',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles and assign permissions
        $owner = Role::create(['name' => 'owner']);
        $owner->givePermissionTo(Permission::all());

        $manager = Role::create(['name' => 'manager']);
        $manager->givePermissionTo([
            'manage-bookings',
            'manage-vendors',
            'manage-ads',
            'manage-payouts',
            'verify-payments',
            'approve-bookings',
            'approve-ads',
        ]);

        $moderator = Role::create(['name' => 'moderator']);
        $moderator->givePermissionTo([
            'manage-users',
            'manage-vendors',
            'manage-bookings',
            'manage-reviews',
        ]);

        $vendor = Role::create(['name' => 'vendor']);
        $vendor->givePermissionTo([
            'manage-properties',
            'approve-bookings',
        ]);

        Role::create(['name' => 'user']);
    }
}