<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PaymentMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            [
                'name' => 'Paystack',
                'slug' => 'paystack',
                'description' => 'Pay with Paystack - Cards, Bank Transfer, USSD',
                'is_active' => false,
                'display_order' => 1,
                'settings' => [
                    'requires_api_keys' => true,
                    'supported_currencies' => ['NGN', 'USD', 'GHS', 'ZAR'],
                ],
            ],
            [
                'name' => 'Flutterwave',
                'slug' => 'flutterwave',
                'description' => 'Pay with Flutterwave - Cards, Bank Transfer, Mobile Money',
                'is_active' => false,
                'display_order' => 2,
                'settings' => [
                    'requires_api_keys' => true,
                    'supported_currencies' => ['NGN', 'USD', 'GHS', 'KES'],
                ],
            ],
            [
                'name' => 'Bank Transfer',
                'slug' => 'bank_transfer',
                'description' => 'Direct bank transfer to our account',
                'is_active' => false,
                'display_order' => 3,
                'settings' => [
                    'bank_name' => '',
                    'account_name' => '',
                    'account_number' => '',
                    'requires_proof' => true,
                ],
            ],
        ];

        foreach ($methods as $method) {
            \App\Models\PaymentMethod::updateOrCreate(
                ['slug' => $method['slug']],
                $method
            );
        }
    }
}
