<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Language;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $languages = [
            [
                'name' => 'English',
                'code' => 'en',
                'flag' => '🇬🇧',
                'is_active' => true,
                'is_default' => true,
                'is_rtl' => false,
            ],
            [
                'name' => 'French',
                'code' => 'fr',
                'flag' => '🇫🇷',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'Spanish',
                'code' => 'es',
                'flag' => '🇪🇸',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'German',
                'code' => 'de',
                'flag' => '🇩🇪',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'Italian',
                'code' => 'it',
                'flag' => '🇮🇹',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'Portuguese',
                'code' => 'pt',
                'flag' => '🇵🇹',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'Arabic',
                'code' => 'ar',
                'flag' => '🇸🇦',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => true,
            ],
            [
                'name' => 'Chinese (Simplified)',
                'code' => 'zh-CN',
                'flag' => '🇨🇳',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'Japanese',
                'code' => 'ja',
                'flag' => '🇯🇵',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
            [
                'name' => 'Russian',
                'code' => 'ru',
                'flag' => '🇷🇺',
                'is_active' => true,
                'is_default' => false,
                'is_rtl' => false,
            ],
        ];

        foreach ($languages as $language) {
            Language::updateOrCreate(
                ['code' => $language['code']],
                $language
            );
        }
    }
}
