<?php

namespace Database\Seeders;

use App\Models\Faq;
use Illuminate\Database\Seeder;

class FaqSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $faqs = [
            // General
            [
                'question' => 'What is ShortStayNG?',
                'answer' => 'ShortStayNG is Nigeria\'s leading comprehensive travel and accommodation platform. We offer premium shortlet accommodations, luxury hotels, and reliable car rental services across major cities in Nigeria.',
                'category' => 'general',
                'display_order' => 1,
            ],
            [
                'question' => 'How does ShortStayNG work?',
                'answer' => 'Simply browse our listings, select your preferred property or car, choose your dates, and complete your booking. You\'ll receive instant confirmation and all necessary details via email and SMS.',
                'category' => 'general',
                'display_order' => 2,
            ],
            [
                'question' => 'Is ShortStayNG available nationwide?',
                'answer' => 'Yes! We have properties and car rental services available across major cities in Nigeria including Lagos, Abuja, Port Harcourt, Ibadan, and many more locations.',
                'category' => 'general',
                'display_order' => 3,
            ],

            // Booking & Reservations
            [
                'question' => 'How do I book a property?',
                'answer' => 'To book a property:
1. Search for properties in your desired location
2. Select your check-in and check-out dates
3. Choose a property that fits your needs
4. Click "Book Now" and fill in your details
5. Complete payment
6. Receive instant confirmation',
                'category' => 'booking',
                'display_order' => 1,
            ],
            [
                'question' => 'Can I modify or cancel my booking?',
                'answer' => 'Yes, you can modify or cancel your booking through your account dashboard. Cancellation policies vary by property, so please check the specific property\'s cancellation policy before booking. Generally, cancellations made 48 hours before check-in are eligible for a full refund.',
                'category' => 'booking',
                'display_order' => 2,
            ],
            [
                'question' => 'What is the minimum booking duration?',
                'answer' => 'Most properties have a minimum booking duration of 1 night. However, some properties may require a minimum stay of 2-3 nights, especially during peak seasons or holidays. Check the property details for specific requirements.',
                'category' => 'booking',
                'display_order' => 3,
            ],
            [
                'question' => 'Do I need to create an account to book?',
                'answer' => 'Yes, you need to create a free account to make bookings. This allows you to manage your reservations, view booking history, save favorite properties, and receive personalized recommendations.',
                'category' => 'booking',
                'display_order' => 4,
            ],

            // Payment & Refunds
            [
                'question' => 'What payment methods do you accept?',
                'answer' => 'We accept multiple payment methods including:
- Debit/Credit Cards (Visa, Mastercard, Verve)
- Bank Transfer
- USSD
- Mobile Money
All payments are processed securely through Flutterwave.',
                'category' => 'payment',
                'display_order' => 1,
            ],
            [
                'question' => 'Is my payment information secure?',
                'answer' => 'Absolutely! We use industry-standard SSL encryption and partner with Flutterwave, a PCI-DSS compliant payment processor. We never store your complete card details on our servers.',
                'category' => 'payment',
                'display_order' => 2,
            ],
            [
                'question' => 'When will I receive my refund?',
                'answer' => 'Approved refunds are processed within 5-7 business days. The refund will be credited to your original payment method. Bank transfers may take an additional 3-5 business days to reflect in your account.',
                'category' => 'payment',
                'display_order' => 3,
            ],
            [
                'question' => 'Are there any hidden fees?',
                'answer' => 'No! We believe in transparent pricing. The price you see is the price you pay. All fees, taxes, and charges are clearly displayed before you complete your booking.',
                'category' => 'payment',
                'display_order' => 4,
            ],

            // Car Rental
            [
                'question' => 'How do I rent a car?',
                'answer' => 'To rent a car:
1. Visit our Car Rental section
2. Select your pickup location and dates
3. Browse available vehicles
4. Choose a car that suits your needs
5. Complete the booking and payment
6. Receive confirmation with pickup details',
                'category' => 'car_rental',
                'display_order' => 1,
            ],
            [
                'question' => 'What are the requirements to rent a car?',
                'answer' => 'To rent a car, you must:
- Be at least 21 years old
- Have a valid driver\'s license (held for at least 1 year)
- Provide a valid ID card or passport
- Have a valid payment method
Some luxury vehicles may have additional age requirements.',
                'category' => 'car_rental',
                'display_order' => 2,
            ],
            [
                'question' => 'Can I rent a car with a driver?',
                'answer' => 'Yes! We offer both self-drive and chauffeur-driven options. You can select your preference when booking. Chauffeur-driven services include a professional driver at an additional cost.',
                'category' => 'car_rental',
                'display_order' => 3,
            ],
            [
                'question' => 'What is included in the car rental price?',
                'answer' => 'Our car rental prices typically include:
- Basic insurance coverage
- Unlimited mileage (for most vehicles)
- 24/7 roadside assistance
- Vehicle maintenance
Additional services like GPS, child seats, or extra insurance can be added for a fee.',
                'category' => 'car_rental',
                'display_order' => 4,
            ],

            // Properties & Listings
            [
                'question' => 'Are all properties verified?',
                'answer' => 'Yes! Every property on ShortStayNG undergoes a thorough verification process. We verify property ownership, inspect facilities, and ensure all listings meet our quality standards before they go live.',
                'category' => 'property',
                'display_order' => 1,
            ],
            [
                'question' => 'Can I list my property on ShortStayNG?',
                'answer' => 'Absolutely! We welcome property owners to list their properties. Simply register as a vendor, submit your property details with photos, and our team will review and verify your listing. Once approved, your property will be visible to thousands of potential guests.',
                'category' => 'property',
                'display_order' => 2,
            ],
            [
                'question' => 'What amenities are typically included?',
                'answer' => 'Amenities vary by property but commonly include:
- WiFi
- Air conditioning
- Kitchen facilities
- TV and entertainment
- Toiletries
- Bedding and towels
- 24/7 security
Check individual property listings for specific amenities.',
                'category' => 'property',
                'display_order' => 3,
            ],
            [
                'question' => 'Can I view a property before booking?',
                'answer' => 'While we provide detailed photos and descriptions, physical viewings before booking are generally not available for shortlet properties. However, you can contact the property owner through our platform for additional information or video tours.',
                'category' => 'property',
                'display_order' => 4,
            ],
        ];

        foreach ($faqs as $faq) {
            Faq::create($faq);
        }
    }
}
