<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    public function run(): void
    {
        $owner = User::create([
            'name' => 'System Owner',
            'email' => 'owner@shortstayng.com',
            'phone' => '+2348000000001',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
        ]);
        $owner->assignRole('owner');

        $manager = User::create([
            'name' => 'System Manager',
            'email' => 'manager@shortstayng.com',
            'phone' => '+2348000000002',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
        ]);
        $manager->assignRole('manager');

        $moderator = User::create([
            'name' => 'System Moderator',
            'email' => 'moderator@shortstayng.com',
            'phone' => '+2348000000003',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'phone_verified_at' => now(),
        ]);
        $moderator->assignRole('moderator');
    }
}
