<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('car_deposit_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('booking_id')->constrained('car_bookings')->onDelete('cascade');
            $table->foreignId('actor_id')->constrained('users')->onDelete('cascade');
            $table->string('actor_role'); // admin, vendor, system
            $table->string('action'); // approved, rejected, refund_paid, etc.
            $table->string('previous_status')->nullable();
            $table->string('new_status');
            $table->decimal('amount', 10, 2)->default(0);
            $table->text('reason')->nullable();
            $table->timestamps();

            $table->index('booking_id');
            $table->index('actor_id');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('car_deposit_logs');
    }
};