<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('discount_deals', function (Blueprint $table) {
            $table->boolean('show_on_homepage')->default(false)->after('is_featured');
            $table->string('banner_title')->nullable()->after('show_on_homepage');
            $table->text('banner_description')->nullable()->after('banner_title');
            $table->string('banner_button_text')->default('Browse Deals')->after('banner_description');
            $table->string('banner_button_link')->default('/properties')->after('banner_button_text');
            $table->string('banner_bg_from')->default('orange-500')->after('banner_button_link');
            $table->string('banner_bg_to')->default('red-500')->after('banner_bg_from');
            $table->string('banner_icon')->default('gift')->after('banner_bg_to');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('discount_deals', function (Blueprint $table) {
            $table->dropColumn([
                'show_on_homepage',
                'banner_title',
                'banner_description',
                'banner_button_text',
                'banner_button_link',
                'banner_bg_from',
                'banner_bg_to',
                'banner_icon',
            ]);
        });
    }
};
