<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('promo_banners', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('discount_code')->nullable();
            $table->string('discount_text')->nullable(); // e.g., "25% OFF", "Save ₦5,000"
            $table->string('button_text')->default('Browse Deals');
            $table->string('button_link')->default('/properties');
            $table->string('background_color_from')->default('orange-500');
            $table->string('background_color_to')->default('red-500');
            $table->string('icon')->default('gift'); // FontAwesome icon name
            $table->boolean('is_active')->default(true);
            $table->integer('display_order')->default(0);
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promo_banners');
    }
};
