<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->timestamp('checked_in_at')->nullable()->after('booking_status');
            $table->timestamp('checked_out_at')->nullable()->after('checked_in_at');
            $table->decimal('caution_deduction_amount', 10, 2)->nullable()->after('caution_refund_reason');
            $table->decimal('caution_refund_amount', 10, 2)->nullable()->after('caution_deduction_amount');
            $table->timestamp('caution_refunded_at')->nullable()->after('caution_refund_amount');
            $table->text('caution_deduction_reason')->nullable()->after('caution_refunded_at');
            $table->json('caution_deduction_photos')->nullable()->after('caution_deduction_reason');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropColumn([
                'checked_in_at',
                'checked_out_at',
                'caution_deduction_amount',
                'caution_refund_amount',
                'caution_refunded_at',
                'caution_deduction_reason',
                'caution_deduction_photos',
            ]);
        });
    }
};
