<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('car_bookings', function (Blueprint $table) {
            $table->decimal('deposit_deduction_amount', 10, 2)->nullable()->after('deposit_refund_amount');
            $table->text('admin_notes')->nullable()->after('deposit_deduction_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('car_bookings', function (Blueprint $table) {
            $table->dropColumn(['deposit_deduction_amount', 'admin_notes']);
        });
    }
};
