<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Insert car rental settings into the settings table
        $settings = [
            [
                'key' => 'car_rental_enabled',
                'value' => '0',
                'type' => 'boolean',
                'group' => 'car_rental',
                'description' => 'Enable or disable car rental feature',
            ],
            [
                'key' => 'car_rental_terms',
                'value' => null,
                'type' => 'textarea',
                'group' => 'car_rental',
                'description' => 'Car rental terms and conditions',
            ],
            [
                'key' => 'car_rental_commission_rate',
                'value' => '15.00',
                'type' => 'number',
                'group' => 'car_rental',
                'description' => 'Platform commission rate for car rentals (%)',
            ],
            [
                'key' => 'car_rental_minimum_age',
                'value' => '21',
                'type' => 'number',
                'group' => 'car_rental',
                'description' => 'Minimum driver age for car rentals',
            ],
            [
                'key' => 'car_rental_minimum_license_years',
                'value' => '1',
                'type' => 'number',
                'group' => 'car_rental',
                'description' => 'Minimum years of driving license for car rentals',
            ],
        ];

        foreach ($settings as $setting) {
            DB::table('settings')->updateOrInsert(
                ['key' => $setting['key']],
                array_merge($setting, [
                    'created_at' => now(),
                    'updated_at' => now(),
                ])
            );
        }
    }

    public function down(): void
    {
        DB::table('settings')->whereIn('key', [
            'car_rental_enabled',
            'car_rental_terms',
            'car_rental_commission_rate',
            'car_rental_minimum_age',
            'car_rental_minimum_license_years',
        ])->delete();
    }
};
