<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('popular_destinations', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // City or State name
            $table->enum('type', ['city', 'state']); // Type of destination
            $table->string('state')->nullable(); // State name (null if type is state)
            $table->string('image'); // Image path
            $table->text('description')->nullable(); // Optional description
            $table->integer('display_order')->default(0); // For sorting
            $table->boolean('active')->default(true); // Show/hide on homepage
            $table->timestamps();
            
            // Index for faster queries
            $table->index(['active', 'display_order']);
            $table->index(['type', 'name']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('popular_destinations');
    }
};
