<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\User;
use App\Models\Vendor;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create a company vendor account for admin-managed properties
        $companyVendor = Vendor::where('company_name', 'ShortStayNG')->first();
        
        if (!$companyVendor) {
            // Find or create a system user for the company
            $systemUser = User::where('email', 'company@shortstayng.com')->first();
            
            if (!$systemUser) {
                $systemUser = User::create([
                    'name' => 'ShortStayNG Company',
                    'email' => 'company@shortstayng.com',
                    'phone' => '0000000000', // System account
                    'password' => bcrypt(\Illuminate\Support\Str::random(32)), // Random password
                    'email_verified_at' => now(),
                ]);
                
                $systemUser->assignRole('vendor');
            }
            
            Vendor::create([
                'user_id' => $systemUser->id,
                'company_name' => 'ShortStayNG',
                'company_description' => 'Official company properties managed by ShortStayNG',
                'kyc_status' => 'approved',
                'verified' => true,
                'verified_at' => now(),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Optionally remove the company vendor
        $companyVendor = Vendor::where('company_name', 'ShortStayNG')->first();
        if ($companyVendor) {
            $companyVendor->delete();
            
            // Optionally delete the system user
            $systemUser = User::where('email', 'company@shortstayng.com')->first();
            if ($systemUser) {
                $systemUser->delete();
            }
        }
    }
};
