<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('properties', function (Blueprint $table) {
            // Change status enum to include 'pending'
            $table->enum('status', ['pending', 'active', 'inactive', 'rejected'])->default('pending')->change();
            $table->text('rejection_reason')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('properties', function (Blueprint $table) {
            $table->enum('status', ['active', 'inactive'])->default('active')->change();
            $table->dropColumn('rejection_reason');
        });
    }
};
