<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vendor_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('description');
            $table->decimal('price_per_night', 10, 2);
            $table->decimal('caution_fee', 10, 2)->default(0);
            $table->integer('max_allowed_guests')->default(2);
            $table->boolean('allow_parties')->default(false);
            $table->timestamp('featured_until')->nullable();
            $table->foreignId('ad_plan_id')->nullable()->constrained()->nullOnDelete();
            $table->enum('status', ['active', 'inactive'])->default('active');
            
            // Location
            $table->string('address');
            $table->string('city');
            $table->string('state');
            $table->string('country')->default('Nigeria');
            $table->decimal('location_lat', 10, 8)->nullable();
            $table->decimal('location_lng', 11, 8)->nullable();
            $table->boolean('map_visible_after_payment')->default(true);
            
            // Property details
            $table->string('house_type'); // Apartment, Villa, etc.
            $table->integer('bedrooms')->default(1);
            $table->integer('beds')->default(1);
            $table->integer('bathrooms')->default(1);
            $table->integer('max_guests')->default(2);
            
            // Features stored as JSON array
            $table->json('highlighted_features')->nullable();
            $table->json('amenities')->nullable();
            $table->json('house_rules')->nullable();
            $table->json('photos')->nullable(); // Array of photo URLs
            
            // Check-in/out times
            $table->time('check_in_from')->default('14:00:00');
            $table->time('check_in_until')->default('22:00:00');
            $table->time('check_out_time')->default('11:00:00');
            
            // Availability
            $table->json('unavailable_dates')->nullable(); // Array of dates
            
            // Cancellation policy
            $table->text('cancellation_policy')->nullable();
            
            // Quality badges
            $table->boolean('quality_standard')->default(false);
            $table->boolean('verified')->default(false);
            $table->boolean('quality_assured')->default(false);
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['vendor_id', 'status']);
            $table->index(['featured_until', 'status']);
            $table->index(['city', 'state']);
            $table->index('price_per_night');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('properties');
    }
};