<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('company_name');
            $table->text('company_description')->nullable();
            $table->string('profile_photo')->nullable();
            $table->decimal('commission_rate_at_signup', 5, 2)->default(15.00);
            $table->boolean('verified')->default(false);
            
            // Bank details
            $table->string('bank_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('account_name')->nullable();
            
            // Payout tracking
            $table->decimal('payout_balance', 15, 2)->default(0);
            $table->decimal('pending_balance', 15, 2)->default(0);
            $table->decimal('total_earned', 15, 2)->default(0);
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index('verified');
            $table->index('user_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vendors');
    }
};