<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Force HTTPS
    |--------------------------------------------------------------------------
    |
    | When enabled, all requests will be forced to use HTTPS.
    | This should be enabled in production.
    |
    */

    'force_https' => env('FORCE_HTTPS', false),

    /*
    |--------------------------------------------------------------------------
    | Rate Limiting
    |--------------------------------------------------------------------------
    |
    | Configure rate limits for various endpoints to prevent abuse.
    |
    */

    'rate_limits' => [
        'api' => env('API_RATE_LIMIT', 60),
        'login' => env('LOGIN_RATE_LIMIT', 5),
        'registration' => env('REGISTRATION_RATE_LIMIT', 3),
        'password_reset' => env('PASSWORD_RESET_RATE_LIMIT', 3),
    ],

    /*
    |--------------------------------------------------------------------------
    | Session Security
    |--------------------------------------------------------------------------
    |
    | Enhanced session security settings.
    |
    */

    'session' => [
        'encrypt' => env('SESSION_ENCRYPT', true),
        'secure_cookie' => env('SESSION_SECURE_COOKIE', true),
        'http_only' => env('SESSION_HTTP_ONLY', true),
        'same_site' => env('SESSION_SAME_SITE', 'strict'),
    ],

    /*
    |--------------------------------------------------------------------------
    | File Upload Security
    |--------------------------------------------------------------------------
    |
    | Configure allowed file types and sizes for uploads.
    |
    */

    'uploads' => [
        'max_size' => [
            'logo' => 2048, // 2MB in KB
            'favicon' => 1024, // 1MB in KB
            'property_image' => 5120, // 5MB in KB
            'kyc_document' => 5120, // 5MB in KB
        ],
        'allowed_types' => [
            'images' => ['jpg', 'jpeg', 'png', 'gif', 'webp'],
            'documents' => ['pdf', 'jpg', 'jpeg', 'png'],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Payment Security
    |--------------------------------------------------------------------------
    |
    | Security settings for payment processing.
    |
    */

    'payment' => [
        'verify_webhooks' => true,
        'log_transactions' => true,
        'require_transaction_pin' => true,
        'min_payout_amount' => 1000, // Minimum payout amount in Naira
        'max_payout_amount' => 5000000, // Maximum payout amount in Naira
    ],

    /*
    |--------------------------------------------------------------------------
    | Admin IP Whitelist
    |--------------------------------------------------------------------------
    |
    | Restrict admin access to specific IP addresses (optional).
    | Leave empty to allow all IPs.
    |
    */

    'admin_ip_whitelist' => env('ADMIN_IP_WHITELIST', ''),

    /*
    |--------------------------------------------------------------------------
    | Audit Logging
    |--------------------------------------------------------------------------
    |
    | Configure what actions should be logged for audit purposes.
    |
    */

    'audit' => [
        'enabled' => true,
        'log_actions' => [
            'admin' => true,
            'vendor' => true,
            'payments' => true,
            'bookings' => true,
        ],
        'retention_days' => 730, // 2 years
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Headers
    |--------------------------------------------------------------------------
    |
    | Configure security headers to be sent with responses.
    |
    */

    'headers' => [
        'x_content_type_options' => 'nosniff',
        'x_frame_options' => 'SAMEORIGIN',
        'x_xss_protection' => '1; mode=block',
        'referrer_policy' => 'strict-origin-when-cross-origin',
        'permissions_policy' => 'geolocation=(), microphone=(), camera=()',
        'hsts' => [
            'enabled' => env('APP_ENV') === 'production',
            'max_age' => 31536000,
            'include_subdomains' => true,
            'preload' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Policy
    |--------------------------------------------------------------------------
    |
    | Configure password requirements.
    |
    */

    'password' => [
        'min_length' => 8,
        'require_uppercase' => true,
        'require_lowercase' => true,
        'require_numbers' => true,
        'require_special_chars' => true,
        'max_age_days' => 90, // Force password change after 90 days (optional)
    ],

    /*
    |--------------------------------------------------------------------------
    | Transaction PIN Policy
    |--------------------------------------------------------------------------
    |
    | Configure transaction PIN requirements for vendor payouts.
    |
    */

    'transaction_pin' => [
        'length' => 4,
        'max_attempts' => 3,
        'lockout_minutes' => 30,
    ],

    /*
    |--------------------------------------------------------------------------
    | Fraud Detection
    |--------------------------------------------------------------------------
    |
    | Configure fraud detection thresholds.
    |
    */

    'fraud_detection' => [
        'enabled' => true,
        'max_bookings_per_hour' => 10,
        'max_failed_payments_per_day' => 5,
        'alert_on_large_payout' => 500000, // Alert if payout > 500k
    ],

    /*
    |--------------------------------------------------------------------------
    | Data Retention
    |--------------------------------------------------------------------------
    |
    | Configure how long to keep various types of data.
    |
    */

    'data_retention' => [
        'cancelled_bookings_days' => 365,
        'failed_payments_days' => 180,
        'activity_logs_days' => 730,
        'expired_discount_codes_days' => 90,
    ],

];
