<?php

namespace App\Services\Payment;

class PaymentFactory
{
    public static function create(string $provider = null): PaymentServiceInterface
    {
        $provider = $provider ?? config('services.payment.default', 'paystack');
        
        return match($provider) {
            'paystack' => new PaystackService(),
            'flutterwave' => new FlutterwaveService(),
            default => throw new \InvalidArgumentException("Unsupported payment provider: {$provider}"),
        };
    }
}