<?php

namespace App\Services;

use App\Models\Booking;
use App\Models\Vendor;
use App\Models\Setting;

class CommissionService
{
    public function calculateCommission(float $amount, ?float $commissionRate = null): array
    {
        if (is_null($commissionRate)) {
            $commissionRate = Setting::get('global_commission_percentage', 15);
        }
        
        $commissionAmount = ($amount * $commissionRate) / 100;
        $vendorAmount = $amount - $commissionAmount;
        
        return [
            'commission_rate' => $commissionRate,
            'commission_amount' => round($commissionAmount, 2),
            'vendor_amount' => round($vendorAmount, 2),
        ];
    }
    
    public function creditVendorBalance(Booking $booking): void
    {
        $vendor = $booking->vendor;
        
        $vendor->increment('pending_balance', $booking->vendor_payout_amount);
        $vendor->increment('total_earned', $booking->vendor_payout_amount);
    }
    
    public function releasePayoutBalance(Vendor $vendor, float $amount): void
    {
        $vendor->decrement('pending_balance', $amount);
        $vendor->increment('payout_balance', $amount);
    }
}