<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidCaptcha implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $sessionCaptcha = session('captcha');
        
        if (!$sessionCaptcha) {
            $fail('CAPTCHA session expired. Please refresh and try again.');
            return;
        }
        
        if (strtoupper($value) !== strtoupper($sessionCaptcha)) {
            $fail('The security code is incorrect. Please try again.');
            return;
        }
        
        // Clear captcha after validation
        session()->forget('captcha');
    }
}
