<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Vendor;

class VendorPolicy
{
    public function view(User $user, Vendor $vendor): bool
    {
        return $user->id === $vendor->user_id
            || $user->hasAnyRole(['owner', 'manager', 'moderator']);
    }

    public function update(User $user, Vendor $vendor): bool
    {
        return $user->id === $vendor->user_id;
    }

    public function verify(User $user): bool
    {
        return $user->hasAnyRole(['owner', 'manager', 'moderator']);
    }

    public function suspend(User $user): bool
    {
        return $user->hasAnyRole(['owner', 'manager']);
    }
}