<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Property;

class PropertyPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Property $property): bool
    {
        return true;
    }

    public function create(User $user): bool
    {
        return $user->hasRole('vendor');
    }

    public function update(User $user, Property $property): bool
    {
        return $user->id === $property->vendor->user_id;
    }

    public function delete(User $user, Property $property): bool
    {
        return $user->id === $property->vendor->user_id
            || $user->hasAnyRole(['owner', 'manager']);
    }
}
