<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Booking;

class BookingPolicy
{
    public function view(User $user, Booking $booking): bool
    {
        return $user->id === $booking->user_id 
            || $user->id === $booking->vendor->user_id
            || $user->hasAnyRole(['owner', 'manager', 'moderator']);
    }

    public function approve(User $user, Booking $booking): bool
    {
        return $user->id === $booking->vendor->user_id 
            && $booking->requires_vendor_approval 
            && $booking->vendor_approval_status === 'pending';
    }

    public function reject(User $user, Booking $booking): bool
    {
        return $user->id === $booking->vendor->user_id 
            && $booking->requires_vendor_approval 
            && $booking->vendor_approval_status === 'pending';
    }

    public function decideCautionRefund(User $user, Booking $booking): bool
    {
        return $user->id === $booking->vendor->user_id 
            && $booking->payment_status === 'paid'
            && $booking->booking_status === 'completed';
    }
}