<?php

// app/Notifications/EmailVerification.php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class EmailVerification extends Notification
{
    use Queueable;

    public function __construct(private string $code)
    {
    }

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('ShortStayNG - Verify Your Account')
            ->greeting('Hello ' . $notifiable->name . '!')
            ->line('Thank you for registering with ShortStayNG.')
            ->line('Your verification code is: **' . $this->code . '**')
            ->line('This code will expire in 10 minutes.')
            ->line('If you did not create an account, no further action is required.')
            ->salutation('Best regards, The ShortStayNG Team');
    }
}
