<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PromoCodeUsage extends Model
{
    protected $table = 'promo_code_usage';
    
    public $timestamps = false;
    
    protected $fillable = [
        'promo_code_id',
        'vendor_id',
        'vendor_ad_id',
        'original_amount',
        'discount_amount',
        'final_amount',
        'used_at',
    ];

    protected $casts = [
        'original_amount' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'final_amount' => 'decimal:2',
        'used_at' => 'datetime',
    ];

    public function promoCode(): BelongsTo
    {
        return $this->belongsTo(PromoCode::class);
    }

    public function vendor(): BelongsTo
    {
        return $this->belongsTo(Vendor::class);
    }

    public function vendorAd(): BelongsTo
    {
        return $this->belongsTo(VendorAd::class);
    }
}
