<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PopularDestination extends Model
{
    protected $fillable = [
        'name',
        'type',
        'state',
        'image',
        'description',
        'display_order',
        'active',
    ];

    protected $casts = [
        'active' => 'boolean',
        'display_order' => 'integer',
    ];

    /**
     * Get the number of properties in this destination
     */
    public function getPropertyCountAttribute()
    {
        if ($this->type === 'state') {
            return Property::active()->where('state', $this->name)->count();
        } else {
            return Property::active()
                ->where('city', $this->name)
                ->where('state', $this->state)
                ->count();
        }
    }

    /**
     * Get the URL for filtering properties by this destination
     */
    public function getUrlAttribute()
    {
        if ($this->type === 'state') {
            return route('properties.index', ['state' => $this->name]);
        } else {
            return route('properties.index', ['city' => $this->name, 'state' => $this->state]);
        }
    }

    /**
     * Scope for active destinations
     */
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    /**
     * Scope for ordered destinations
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('display_order', 'asc')->orderBy('name', 'asc');
    }
}
