<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NearbyAttractionsCache extends Model
{
    use HasFactory;

    protected $table = 'nearby_attractions_cache';

    protected $fillable = [
        'property_id',
        'latitude',
        'longitude',
        'attractions',
        'cached_at',
        'expires_at',
    ];

    protected $casts = [
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'attractions' => 'array',
        'cached_at' => 'datetime',
        'expires_at' => 'datetime',
    ];

    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    public function isExpired(): bool
    {
        return $this->expires_at->isPast();
    }

    public function scopeValid($query)
    {
        return $query->where('expires_at', '>', now());
    }
}