<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DiscountDealUsage extends Model
{
    protected $table = 'discount_deal_usage';
    
    public $timestamps = false;
    
    protected $fillable = [
        'discount_deal_id',
        'user_id',
        'booking_id',
        'original_amount',
        'discount_amount',
        'final_amount',
        'used_at',
    ];

    protected $casts = [
        'original_amount' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'final_amount' => 'decimal:2',
        'used_at' => 'datetime',
    ];

    public function discountDeal(): BelongsTo
    {
        return $this->belongsTo(DiscountDeal::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function booking(): BelongsTo
    {
        return $this->belongsTo(Booking::class);
    }
}
