<?php

namespace App\Listeners;

use App\Events\BookingCreated;
use App\Notifications\BookingNotification;

class SendBookingNotification
{
    public function handle(BookingCreated $event): void
    {
        $booking = $event->booking;
        
        // Notify vendor
        $booking->vendor->user->notify(new BookingNotification($booking, 'created'));
    }
}