<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\PromoCodeService;
use Illuminate\Http\Request;

class PromoCodeController extends Controller
{
    protected $promoService;

    public function __construct(PromoCodeService $promoService)
    {
        $this->promoService = $promoService;
    }

    public function validate(Request $request)
    {
        try {
            $request->validate([
                'code' => 'required|string',
                'amount' => 'required|numeric|min:0',
            ]);

            if (!auth()->check()) {
                return response()->json([
                    'valid' => false,
                    'message' => 'You must be logged in to use promo codes.'
                ], 200); // Return 200 with error message instead of 401
            }

            $vendor = auth()->user()->vendor;
            
            if (!$vendor) {
                return response()->json([
                    'valid' => false,
                    'message' => 'Only vendors can use promo codes.'
                ], 200); // Return 200 with error message instead of 403
            }

            $result = $this->promoService->validateCode(
                $request->code,
                $vendor,
                $request->amount
            );

            return response()->json($result);
        } catch (\Exception $e) {
            return response()->json([
                'valid' => false,
                'message' => 'Error validating code: ' . $e->getMessage()
            ], 200);
        }
    }
}
