<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\DiscountDealService;
use Illuminate\Http\Request;

class DiscountCodeController extends Controller
{
    protected $discountService;

    public function __construct(DiscountDealService $discountService)
    {
        $this->discountService = $discountService;
    }

    public function validate(Request $request)
    {
        $request->validate([
            'code' => 'required|string',
            'amount' => 'required|numeric|min:0',
        ]);

        if (!auth()->check()) {
            return response()->json([
                'valid' => false,
                'message' => 'You must be logged in to use discount codes.'
            ], 401);
        }

        $result = $this->discountService->validateCode(
            $request->code,
            auth()->user(),
            $request->amount
        );

        return response()->json($result);
    }
}
