<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Vendor;
use App\Models\Booking;
use App\Models\CarBooking;
use App\Models\Transaction;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_users' => User::role('user')->count(),
            'total_vendors' => Vendor::count(),
            'active_vendors' => Vendor::where('verified', true)->count(),
            'total_bookings' => Booking::count(),
            'pending_bookings' => Booking::pending()->count(),
            'total_revenue' => Transaction::completed()
                ->where('type', 'booking_payment')
                ->sum('amount'),
            'property_commission' => Booking::where('payment_status', 'paid')
                ->sum('commission_amount'),
            'car_commission' => CarBooking::where('payment_status', 'paid')
                ->sum('commission_amount'),
            'total_commission' => Booking::where('payment_status', 'paid')->sum('commission_amount') + 
                                 CarBooking::where('payment_status', 'paid')->sum('commission_amount'),
            'total_car_bookings' => CarBooking::count(),
            'pending_car_bookings' => CarBooking::where('status', 'pending')->count(),
            'pending_ad_approvals' => \App\Models\VendorAd::pendingApproval()->count(),
        ];
        
        $recentBookings = Booking::with(['user', 'property', 'vendor'])
            ->latest()
            ->limit(10)
            ->get();
        
        $pendingVerifications = Booking::pendingAdminVerification()
            ->with(['user', 'property'])
            ->latest()
            ->limit(10)
            ->get();
        
        return view('admin.dashboard', compact('stats', 'recentBookings', 'pendingVerifications'));
    }
}
