<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class RecalculateBookingCommissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bookings:recalculate-commissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Recalculate commission for all bookings (excludes caution fee from commission)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Recalculating commissions for all bookings...');
        
        $bookings = \App\Models\Booking::all();
        $updated = 0;
        
        foreach ($bookings as $booking) {
            // Recalculate commission based on subtotal only (not including caution fee)
            $commissionAmount = ($booking->subtotal * $booking->commission_rate) / 100;
            $vendorPayoutAmount = $booking->subtotal - $commissionAmount;
            
            // Only update if values have changed
            if ($booking->commission_amount != $commissionAmount || $booking->vendor_payout_amount != $vendorPayoutAmount) {
                $booking->update([
                    'commission_amount' => $commissionAmount,
                    'vendor_payout_amount' => $vendorPayoutAmount,
                ]);
                $updated++;
                $this->info("Updated booking #{$booking->id}");
            }
        }
        
        $this->info("Completed! Updated {$updated} bookings.");
        
        return 0;
    }
}
