<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class GeocodeProperties extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'properties:geocode';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Geocode properties that are missing coordinates';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Geocoding properties without coordinates...');
        
        $properties = \App\Models\Property::whereNull('location_lat')
            ->orWhereNull('location_lng')
            ->get();
        
        if ($properties->isEmpty()) {
            $this->info('All properties already have coordinates!');
            return 0;
        }
        
        $this->info("Found {$properties->count()} properties without coordinates");
        
        $geocoder = app(\App\Services\Maps\GoogleMapsService::class);
        $updated = 0;
        $failed = 0;
        
        foreach ($properties as $property) {
            $address = "{$property->address}, {$property->city}, {$property->state}, Nigeria";
            
            $this->info("Geocoding: {$property->title}");
            
            $result = $geocoder->geocodeAddress($address);
            
            if ($result) {
                $property->update([
                    'location_lat' => $result['latitude'],
                    'location_lng' => $result['longitude'],
                ]);
                $updated++;
                $this->info("  ✓ Success: {$result['latitude']}, {$result['longitude']}");
            } else {
                $failed++;
                $this->error("  ✗ Failed to geocode");
            }
            
            // Sleep to avoid hitting API rate limits
            sleep(1);
        }
        
        $this->info("\nCompleted!");
        $this->info("Updated: {$updated}");
        $this->info("Failed: {$failed}");
        
        return 0;
    }
}
