<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CreditVendorBalances extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'vendors:credit-balances';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Credit vendor balances for all paid bookings';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Crediting vendor balances for paid bookings...');
        
        // Get all paid and confirmed bookings
        $bookings = \App\Models\Booking::where('payment_status', 'paid')
            ->where('booking_status', 'confirmed')
            ->get();
        
        $this->info("Found {$bookings->count()} paid bookings");
        
        // Reset all vendor balances first
        $this->info('Resetting vendor balances...');
        \App\Models\Vendor::query()->update([
            'pending_balance' => 0,
            'total_earned' => 0,
        ]);
        
        // Recalculate from bookings
        foreach ($bookings as $booking) {
            $vendor = $booking->vendor;
            $vendor->increment('pending_balance', $booking->vendor_payout_amount);
            $vendor->increment('total_earned', $booking->vendor_payout_amount);
            
            $this->info("Credited ₦{$booking->vendor_payout_amount} to {$vendor->company_name} for booking #{$booking->id}");
        }
        
        $this->info('Completed!');
        
        return 0;
    }
}
