# 🌐 Translation Quick Start Guide

## 🚀 Getting Started (3 Steps)

### **Step 1: Run Setup Commands**
```bash
php artisan migrate
php artisan db:seed --class=LanguageSeeder
php artisan cache:clear
```

### **Step 2: Verify Language Selector**
- Visit your homepage
- Look for the language dropdown (🇬🇧 English ▼)
- Click and select a language
- Page reloads with new language

### **Step 3: Start Using Translations**
Replace hardcoded text with translation keys:

**Before:**
```blade
<h1>Welcome to ShortStayNG</h1>
<a href="/properties">Properties</a>
<button>Book Now</button>
```

**After:**
```blade
<h1>{{ __('messages.home') }}</h1>
<a href="/properties">{{ __('messages.properties') }}</a>
<button>{{ __('messages.book_now') }}</button>
```

---

## 📚 Available Translation Keys

### **Navigation**
```blade
{{ __('messages.home') }}           // Home
{{ __('messages.properties') }}     // Properties
{{ __('messages.car_rentals') }}    // Car Rentals
{{ __('messages.about') }}          // About
{{ __('messages.contact') }}        // Contact
{{ __('messages.login') }}          // Login
{{ __('messages.register') }}       // Register
{{ __('messages.logout') }}         // Logout
```

### **Dashboard**
```blade
{{ __('messages.dashboard') }}      // Dashboard
{{ __('messages.my_bookings') }}    // My Bookings
{{ __('messages.favorites') }}      // Favorites
{{ __('messages.profile') }}        // Profile
{{ __('messages.settings') }}       // Settings
```

### **Property/Car**
```blade
{{ __('messages.search_properties') }}  // Search Properties
{{ __('messages.view_details') }}       // View Details
{{ __('messages.book_now') }}           // Book Now
{{ __('messages.per_night') }}          // per night
{{ __('messages.per_day') }}            // per day
{{ __('messages.available') }}          // Available
{{ __('messages.seats') }}              // Seats
{{ __('messages.transmission') }}       // Transmission
```

### **Booking**
```blade
{{ __('messages.check_in') }}           // Check In
{{ __('messages.check_out') }}          // Check Out
{{ __('messages.guests') }}             // Guests
{{ __('messages.total_price') }}        // Total Price
{{ __('messages.confirm_booking') }}    // Confirm Booking
{{ __('messages.cancel_booking') }}     // Cancel Booking
```

### **Common**
```blade
{{ __('messages.search') }}         // Search
{{ __('messages.filter') }}         // Filter
{{ __('messages.sort_by') }}        // Sort By
{{ __('messages.price') }}          // Price
{{ __('messages.location') }}       // Location
{{ __('messages.category') }}       // Category
{{ __('messages.reviews') }}        // Reviews
{{ __('messages.rating') }}         // Rating
{{ __('messages.description') }}    // Description
{{ __('messages.amenities') }}      // Amenities
{{ __('messages.photos') }}         // Photos
```

### **Actions**
```blade
{{ __('messages.save') }}           // Save
{{ __('messages.cancel') }}         // Cancel
{{ __('messages.delete') }}         // Delete
{{ __('messages.edit') }}           // Edit
{{ __('messages.update') }}         // Update
{{ __('messages.submit') }}         // Submit
{{ __('messages.back') }}           // Back
{{ __('messages.next') }}           // Next
```

### **Messages**
```blade
{{ __('messages.success') }}        // Success!
{{ __('messages.error') }}          // Error!
{{ __('messages.loading') }}        // Loading...
{{ __('messages.no_results') }}     // No results found
```

---

## 🎯 Common Use Cases

### **1. Navigation Menu**
```blade
<nav>
    <a href="/">{{ __('messages.home') }}</a>
    <a href="/properties">{{ __('messages.properties') }}</a>
    <a href="/cars">{{ __('messages.car_rentals') }}</a>
    <a href="/contact">{{ __('messages.contact') }}</a>
</nav>
```

### **2. Property Card**
```blade
<div class="property-card">
    <h3>{{ $property->name }}</h3>
    <p>₦{{ number_format($property->price) }} {{ __('messages.per_night') }}</p>
    <span class="badge">{{ __('messages.available') }}</span>
    <a href="{{ route('properties.show', $property) }}">
        {{ __('messages.view_details') }}
    </a>
</div>
```

### **3. Booking Form**
```blade
<form>
    <label>{{ __('messages.check_in') }}</label>
    <input type="date" name="check_in">
    
    <label>{{ __('messages.check_out') }}</label>
    <input type="date" name="check_out">
    
    <label>{{ __('messages.guests') }}</label>
    <input type="number" name="guests">
    
    <button>{{ __('messages.book_now') }}</button>
</form>
```

### **4. Search Bar**
```blade
<div class="search-bar">
    <input type="text" placeholder="{{ __('messages.search_properties') }}">
    <button>{{ __('messages.search') }}</button>
</div>
```

### **5. Flash Messages**
```blade
@if(session('success'))
    <div class="alert alert-success">
        {{ __('messages.success') }} {{ session('success') }}
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger">
        {{ __('messages.error') }} {{ session('error') }}
    </div>
@endif
```

---

## 🔧 Adding New Translations

### **Step 1: Add to English File**
Edit `/resources/lang/en/messages.php`:
```php
return [
    // ... existing translations
    'new_key' => 'New Translation',
];
```

### **Step 2: Add to Other Languages**
Edit `/resources/lang/fr/messages.php`:
```php
return [
    // ... existing translations
    'new_key' => 'Nouvelle Traduction',
];
```

### **Step 3: Use in Views**
```blade
{{ __('messages.new_key') }}
```

---

## 🌍 Supported Languages

| Flag | Language | Code | Status |
|------|----------|------|--------|
| 🇬🇧 | English | en | ✅ Default |
| 🇫🇷 | French | fr | ✅ Active |
| 🇪🇸 | Spanish | es | ✅ Active |
| 🇩🇪 | German | de | ✅ Active |
| 🇮🇹 | Italian | it | ✅ Active |
| 🇵🇹 | Portuguese | pt | ✅ Active |
| 🇸🇦 | Arabic | ar | ✅ Active (RTL) |
| 🇨🇳 | Chinese | zh-CN | ✅ Active |
| 🇯🇵 | Japanese | ja | ✅ Active |
| 🇷🇺 | Russian | ru | ✅ Active |

---

## 💡 Pro Tips

1. **Always use translation keys** instead of hardcoded text
2. **Keep keys descriptive** (e.g., `book_now` not `btn1`)
3. **Group related translations** in the same file
4. **Test in multiple languages** before deploying
5. **Use short keys** for better performance

---

## 🐛 Troubleshooting

### **Language selector not showing?**
```bash
php artisan view:clear
php artisan cache:clear
```

### **Translations not working?**
```bash
# Check if language files exist
ls resources/lang/en/

# Clear config cache
php artisan config:clear
```

### **Language not persisting?**
```bash
# Check session configuration
php artisan session:table
php artisan migrate
```

---

## ✅ Quick Checklist

- [ ] Migrations run
- [ ] Languages seeded
- [ ] Language selector visible
- [ ] Can switch languages
- [ ] Translations display correctly
- [ ] Session persists language choice

---

**You're all set! Start translating your views now!** 🎉

For detailed documentation, see `MULTI_LANGUAGE_IMPLEMENTATION.md`
